# -*- coding: utf-8 -*-

import logging

from sandbox.sandboxsdk import process
from sandbox.sandboxsdk import svn

from sandbox.projects.common.build.ArcadiaTask import ArcadiaTask
import sandbox.projects.common.constants as consts


class BaseArcadiaProjectTask(ArcadiaTask):
    def init_ctx_for_params(self, params):
        ctx = {}
        base_build_task_ctx = ArcadiaTask.initCtx(self)
        if base_build_task_ctx:
            ctx.update(base_build_task_ctx)
        for parameter in params:
            ctx[parameter.name] = parameter.default_value
        return ctx

    def pre_execute(self):
        assert consts.ARCADIA_URL_KEY in self.ctx
        parsed_url = svn.Arcadia.parse_url(self.ctx.get(consts.ARCADIA_URL_KEY))
        self.ctx['ap_arcadia_revision'] = parsed_url.revision
        self.ctx['ap_arcadia_trunk'] = parsed_url.trunk
        self.ctx['ap_arcadia_branch'] = parsed_url.branch
        self.ctx['ap_arcadia_tag'] = parsed_url.tag

    def get_base_resource_attrs(self):
        return {
            'arcadia_revision': self.ctx.get('ap_arcadia_revision'),
            'arcadia_trunk': self.ctx.get('ap_arcadia_trunk'),
            'arcadia_branch': self.ctx.get('ap_arcadia_branch'),
            'arcadia_tag': self.ctx.get('ap_arcadia_tag')
        }

    @staticmethod
    def run_cmd(cmd, log_prefix, work_dir, stdout=None):
        logging.info('Work dir for subprocess: %s' % work_dir)
        process.run_process(cmd, log_prefix=log_prefix, work_dir=work_dir,
                            outputs_to_one_file=False, stdout=stdout)
