"""
    Here are constants which are related to YaPackage and YaPackage2 tasks.
"""
import enum
import re


class PackageType(enum.Enum):
    TARBALL = "tarball"
    DEBIAN = "debian"
    DOCKER = "docker"
    RPM = "rpm"
    WHEEL = "wheel"
    AAR = "aar"
    NPM = "npm"


DEBUG = "debug"
RELEASE = "release"

PACKAGES_FILE = "packages.json"
PACKAGE_RESOURCES = "_package_resources"
VAULT_PATTERN = re.compile(r"\$\(vault:(?P<dst>file|value):(?P<owner>[^:]+):(?P<name>[^:]+)\)")
ENV_VAR_PATTERN = re.compile(r"^\s*(\b[a-zA-Z_]\w*=((\'[^\']*\')|(\"[^\"]*\")|([^\s\'\"]+))(\s+|$))+$")

DUPLOAD_CONF = {
    'common': {
        'fqdn': 'common.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/common/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'augur-common': {
        'fqdn': 'augur-common.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/augur-common/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'mapsmobi-common': {
        'fqdn': 'mapsmobi-common.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/mapsmobi-common/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'mapsmobi-linux': {
        'fqdn': 'mapsmobi-linux.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/mapsmobi-linux/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'mapsmobi-windows': {
        'fqdn': 'mapsmobi-windows.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/mapsmobi-windows/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'mapsmobi-darwin': {
        'fqdn': 'mapsmobi-darwin.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/mapsmobi-darwin/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'mapsmobi-tools': {
        'fqdn': 'mapsmobi-tools.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/mapsmobi-tools/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'search': {
        'fqdn': 'search.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/search/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'search-arm64': {
        'fqdn': 'search.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/search-arm64/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'search-kernel': {
        'fqdn': 'search-kernel.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/search-kernel/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'search-lucid': {
        'fqdn': 'search-lucid.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/search-lucid/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'search-precise': {
        'fqdn': 'search-precise.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/search-precise/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'search-test': {
        'fqdn': 'search-test.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/search-test/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'search-trusty': {
        'fqdn': 'search-trusty.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/search-trusty/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'search-xenial': {
        'fqdn': 'search-xenial.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/search-xenial/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'search-focal': {
        'fqdn': 'search-focal.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/search-focal/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'yabs-precise': {
        'fqdn': 'yabs-precise.dupload.bsdist.yandex.net',
        'method': 'scpb',
        'incoming': '/repo/yabs-precise/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'yabs-trusty': {
        'fqdn': 'yabs-precise.dupload.bsdist.yandex.net',
        'method': 'scpb',
        'incoming': '/repo/yabs-trusty/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'yandex-bionic': {
        'fqdn': 'yandex-bionic.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/yandex-bionic/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'yandex-focal': {
        'fqdn': 'yandex-focal.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/yandex-focal/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'yandex-hardy': {
        'fqdn': 'yandex-hardy.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/yandex-hardy/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'yandex-lucid': {
        'fqdn': 'yandex-lucid.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/yandex-lucid/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'yandex-precise': {
        'fqdn': 'yandex-precise.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/yandex-precise/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'yandex-trusty': {
        'fqdn': 'yandex-trusty.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/yandex-trusty/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'yandex-xenial': {
        'fqdn': 'yandex-xenial.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/yandex-xenial/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'yandex-taxi-common': {
        'fqdn': 'yandex-taxi-common.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/yandex-taxi-common/mini-dinstall/incoming/',
        'dinstall_runs': 0,
    },
    'yandex-taxi-trusty': {
        'fqdn': 'yandex-taxi-trusty.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/yandex-taxi-trusty/mini-dinstall/incoming/',
        'dinstall_runs': 0,
    },
    'yandex-taxi-xenial': {
        'fqdn': 'yandex-taxi-xenial.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/yandex-taxi-xenial/mini-dinstall/incoming/',
        'dinstall_runs': 0,
    },
    'passport-precise': {
        'fqdn': 'passport-precise.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/passport-precise/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'passport-trusty': {
        'fqdn': 'passport-trusty.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/passport-trusty/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'passport-xenial': {
        'fqdn': 'passport-xenial.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/passport-xenial/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'passport-bionic': {
        'fqdn': 'passport-bionic.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/passport-bionic/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'passport-focal': {
        'fqdn': 'passport-focal.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/passport-focal/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'passport': {
        'fqdn': 'passport.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/passport/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'mail-trusty': {
        'fqdn': 'mail-trusty.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/mail-trusty/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'mdb-bionic': {
        'fqdn': 'mdb-bionic.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/mdb-bionic/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'ydf': {
        'fqdn': 'ydf.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/ydf/mini-dinstall/incoming/',
        'dinstall_runs': 0,
    },
    'market-trusty': {
        'fqdn': 'market-trusty.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/market-trusty/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'market-precise': {
        'fqdn': 'market-precise.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/market-precise/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'market-xenial': {
        'fqdn': 'market-xenial.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/market-xenial/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'market-common': {
        'fqdn': 'market-common.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/market-common/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'market-robotics-focal': {
        'fqdn': 'market-robotics-focal.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/market-robotics-focal/mini-dinstall/incoming/',
        'dinstall_runs': 0,
    },
    'market-robotics-focal-arm64': {
        'fqdn': 'market-robotics-focal-arm64.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/market-robotics-focal-arm64/mini-dinstall/incoming/',
        'dinstall_runs': 0,
    },
    'market-robotics-focal-external': {
        'fqdn': 'market-robotics-focal-external.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/market-robotics-focal-external/mini-dinstall/incoming/',
        'dinstall_runs': 0,
    },
    'market-robotics-focal-external-arm64': {
        'fqdn': 'market-robotics-focal-external-arm64.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/market-robotics-focal-external-arm64/mini-dinstall/incoming/',
        'dinstall_runs': 0,
    },
    'crypta-precise': {
        'fqdn': 'crypta-precise.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/crypta-precise/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'crypta-trusty': {
        'fqdn': 'crypta-trusty.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/crypta-trusty/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'crypta-common': {
        'fqdn': 'crypta-common.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/crypta-common/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'strm-common': {
        'fqdn': 'strm-common.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/strm-common/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'strm-trusty': {
        'fqdn': 'strm-trusty.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/strm-trusty/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'strm-xenial': {
        'fqdn': 'strm-xenial.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/strm-xenial/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'strm-bionic': {
        'fqdn': 'strm-bionic.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/strm-bionic/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'strm-ffmpeg-cuda': {
        'fqdn': 'strm-ffmpeg-cuda.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/strm-ffmpeg-cuda/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'strm-ffmpeg-common': {
        'fqdn': 'strm-ffmpeg-common.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/strm-ffmpeg-common/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'statbox-common': {
        'fqdn': 'statbox-common.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/statbox-common/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'yt-common': {
        'fqdn': 'yt-common.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/yt-common/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'yt-precise': {
        'fqdn': 'yt-precise.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/yt-precise/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'yt-trusty': {
        'fqdn': 'yt-trusty.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/yt-trusty/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'direct-trusty': {
        'fqdn': 'direct-trusty.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/direct-trusty/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'direct-xenial': {
        'fqdn': 'direct-xenial.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/direct-xenial/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'storage-common': {
        'fqdn': 'storage-common.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/storage-common/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'storage-trusty': {
        'fqdn': 'storage-trusty.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/storage-trusty/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'storage-bionic': {
        'fqdn': 'storage-bionic.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/storage-bionic/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'storage-focal': {
        'fqdn': 'storage-focal.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/storage-focal/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'mtrs-common': {
        'fqdn': 'mtrs-common.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/mtrs-common/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'metrika': {
        'fqdn': 'metrika.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/metrika/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'metrika-common': {
        'fqdn': 'metrika-common.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/metrika-common/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'metrika-trusty': {
        'fqdn': 'metrika-trusty.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/metrika-trusty/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'metrika-xenial': {
        'fqdn': 'metrika-xenial.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/metrika-xenial/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'yandex-disk-common': {
        'fqdn': 'yandex-disk-common.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/yandex-disk-common/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'yandex-disk-trusty': {
        'fqdn': 'yandex-disk-trusty.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/yandex-disk-trusty/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'yandex-cloud': {
        'fqdn': 'yandex-cloud.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/yandex-cloud/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'qloud': {
        'fqdn': 'qloud.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/qloud/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'media-java': {
        'fqdn': 'media-java.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/media-java/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'ofd': {
        'fqdn': 'ofd.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/ofd/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'paysys-trusty': {
        'fqdn': 'paysys-trusty.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/paysys-trusty/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'paysys-bionic': {
        'fqdn': 'paysys-bionic.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/paysys-bionic/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'paysys-precise': {
        'fqdn': 'paysys-precise.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/paysys-precise/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'paysys': {
        'fqdn': 'paysys.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/paysys/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'yandex-musl': {
        'fqdn': 'yandex-musl.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/yandex-musl/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'verstka': {
        'fqdn': 'verstka.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/verstka/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'yandex-qa': {
        'fqdn': 'yandex-qa.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/yandex-qa/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'cocaine-v12-trusty': {
        'fqdn': 'cocaine-v12-trusty.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/cocaine-v12-trusty/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
    'edadeal': {
        'fqdn': 'edadeal.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/edadeal/mini-dinstall/incoming/',
        'dinstall_runs': 1
    },
    'load-xenial': {
        'fqdn': 'load-xenial.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/load-xenial/mini-dinstall/incoming/',
        'dinstall_runs': 1
    },
    'load-precise': {
        'fqdn': 'load-precise.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/load-precise/mini-dinstall/incoming/',
        'dinstall_runs': 1
    },
    'sysmon-trusty': {
        'fqdn': 'sysmon-trusty.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/sysmon-trusty/mini-dinstall/incoming/',
        'dinstall_runs': 1
    },
    'cacus': {
        'fqdn': 'cacus.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/cacus/mini-dinstall/incoming/',
        'dinstall_runs': 0
    },
    'noc': {
        'fqdn': 'noc.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/noc/mini-dinstall/incoming/',
        'dinstall_runs': 1
    },
    'mnt-traf': {
        'fqdn': 'mnt-traf.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/mnt-traf/mini-dinstall/incoming/',
        'dinstall_runs': 1
    },
    'mnt-traf-trusty': {
        'fqdn': 'mnt-traf-trusty.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/mnt-traf-trusty/mini-dinstall/incoming/',
        'dinstall_runs': 1
    },
    'mnt-traf-bionic': {
        'fqdn': 'mnt-traf-bionic.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/mnt-traf-bionic/mini-dinstall/incoming/',
        'dinstall_runs': 1
    },
    'mnt-traf-focal': {
        'fqdn': 'mnt-traf-focal.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/mnt-traf-focal/mini-dinstall/incoming/',
        'dinstall_runs': 1
    },
    'cauth': {
        'fqdn': 'cauth.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/cauth/mini-dinstall/incoming/',
        'dinstall_runs': 1
    },
    'cauth-arm64': {
        'fqdn': 'cauth-arm64.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/cauth-arm64/mini-dinstall/incoming/',
        'dinstall_runs': 1
    },
    'sdc': {
        'fqdn': 'sdc.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/sdc/mini-dinstall/incoming/',
        'dinstall_runs': 1
    },
    'sdc-bionic': {
        'fqdn': 'sdc-bionic.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/sdc-bionic/mini-dinstall/incoming/',
        'dinstall_runs': 1
    },
    'sdc-focal': {
        'fqdn': 'sdc-focal.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/sdc-focal/mini-dinstall/incoming/',
        'dinstall_runs': 1
    },
    'haas': {
        'fqdn': 'haas.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/haas/mini-dinstall/incoming/',
        'dinstall_runs': 0
    },
    'haas-factory': {
        'fqdn': 'haas-factory.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/haas-factory/mini-dinstall/incoming/',
        'dinstall_runs': 0
    },
    'haas-xenial': {
        'fqdn': 'haas-xenial.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/haas-xenial/mini-dinstall/incoming/',
        'dinstall_runs': 0
    },
    'haas-focal': {
        'fqdn': 'haas-focal.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/haas-focal/mini-dinstall/incoming/',
        'dinstall_runs': 0
    },
    'contest': {
        'fqdn': 'contest.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/contest/mini-dinstall/incoming/',
        'dinstall_runs': 0
    },
    'cloud-netinfra': {
        'fqdn': 'cloud-netinfra.dupload.dist.yandex.ru',
        'method': 'scpb',
        'incoming': '/repo/cloud-netinfra/mini-dinstall/incoming/',
        'dinstall_runs': 1,
    },
}

VAULT_OWNERS = {
    'mekagem': 'mekagem',
    'roboslone': 'MARTY',
    'robot-gerrit': 'MAIL',
    'robot-ofd': 'OFD',
    'robot-admins': 'ROBOT-ADMINS',
    'robot-augur-build': 'AUGUR',
    'robot-build-tools': 'BUILD_TOOLS',
    'robot-eksperimentus': 'AB-TESTING',
    'robot-geosearch': 'GEOMETA-SEARCH',
    'robot-gigaminer': 'GIGAMINER',
    'robot-mira': 'VIDEODEV',
    'robot-ocr': 'RECOGNITION',
    'robot-raskolnikov': 'TICKET_PARSER',
    'robot-remorph': 'REMORPH',
    'robot-rtmr-build': 'RTMR-DEV',
    'robot-kikimr-dev': 'STORAGE',
    'robot-simcity': 'TEAMCITY',
    'somov': 'somov',
    'svc': 'svc',
    'breakneck': 'breakneck',
    'yabs-commiter': 'ADVQUALITY',
    'zomb-distbuild': 'zomb-distbuild',
    'zomb-prj-216': 'MR-USERS',
    'robot-sb-openssl': 'MDS-BUILDER-ROBOT2',
    'robot-bro-admin': 'BROWSER-ADMIN',
    'robot-bro-merge': 'BROWSER-MERGE',
    'robot-disk-cloud': 'DISK-ADMIN',
    'robot-disk-j-build': 'DISK-ADMIN',
    'robot-market-packer': 'MARKETSRE',
    'robot-passp-sandbox': 'PASSPORT',
    'robot-passport-front': 'PASSPORT-FRONTEND',
    'robot-secretary': 'CRYPTA',
    'robot-ukrop-sandbox': 'UKROP-ROBOT',
    'robot-strm-sandbox': 'STRM',
    'robot-error-booster': 'ERROR_BOOSTER',
    'robot-logbroker': 'LOGBROKER',
    'robot-logbroker-ci': 'LOGBROKER',
    'robot-antirobot': 'ANTIROBOT',
    'robot-direct-debsign': 'DIRECT',
    'robot-maps-duploader': 'MAPS',
    'robot-mapkit-ci': 'MAPS-CORE-MOBILE-CI',
    'robot-metrika-admin': 'METRIKA',
    'robot-metrika-test': 'METRIKA',
    'robot-yasm-golovan': 'YASM',
    'robot-yt-openstack': 'YT_ROBOT',
    'robot-balancer-cert': 'TRAFFIC-TEAM',
    'robot-qloud': 'QLOUD-DEV',
    'robot-teamcity-music': 'MUSIC',
    'robot-ps-prod-ci': 'PAYSYSADMIN',
    'robot-ps-registry': 'PAYSYSADMIN',
    'robot-userfeat': 'USERFEAT',
    'robot-rainbow-dash': 'BALANCER',
    'robot-walle': 'WALLE',
    'robot-taxi-sandload': 'ROBOT_TAXI_SANDLOAD',
    'robot-yc-sandbox': 'YANDEX_CLOUD',
    'robot-checkmarx': 'SECURITY',
    'robot-gideon': 'SECURITY',
    'robot-ugcdb': 'UGC',
    'robot-solomon': 'SOLOMON',
    'robot-solomon-build': 'SOLOMON',
    'robot-skc': 'ZORA-YF',
    'robot-mb-ci': 'MEDIABILLING',
    'robot-pgaas-ci': 'MDB',
    'robot-marketplace': 'YCMARKETPLACE',
    'robot-zoidberg': 'YC_BOOTSTRAP',
    'robot-yc-ci': 'YC_BOOTSTRAP',
    'robot-yc-compute': 'YC_COMPUTE',
    'robot-yc-infra': 'YC_INFRA',
    'robot-billing-ci': 'BILLING-CI',
    'robot-zora': 'ZORA',
    'robot-eddl-testenv': 'EDADEAL',
    'robot-partner': 'PARTNER',
    'robot-antivirus': 'ANTIMALWARE_TESTENV',
    'robot-puncher-deploy': 'PUNCHER-DEV',
    'robot-emily': 'IPTEL',
    'robot-nocdeploy': 'NOCDEV',
    'robot-lunapark': 'LOAD',
    'robot-yc-tracing-ci': 'CLOUD_PLATFORM',
    'robot-ci-sessions': 'USERSESSIONSTOOLS',
    'robot-antifraud': 'ANTIFRAUD',
    'robot-rtc-builder': 'RCCS-ADMINS',
    'robot-yc-iam': 'YC_IAM',
    'robot-animals': 'ANIMALS',
    'robot-taxi-ops-deb': 'TAXIADMIN',
    'robot-ttmgmt-builder': 'MNT_TRAF',
    'robot-iss-build-bot': 'ISS',
    'robot-arc-deploy': 'ARC',
    'arcadia-devtools': 'YATOOL',
    'robot-telephonist': 'TELEPHONY-DEV',
    'robot-cauth': 'CAUTH',
    'robot-garden': 'MAPS_GARDEN',
    'robot-cult': 'MEDIAADMIN',
    'robot-nosecone': 'SDC-INFRA',
    'robot-afisha-deploy': 'AFISHA',
    'robot-taxi-prd-38327': 'TAXI_ML_MODELS_DEPLOY_PRODUCTION',
    'robot-taxi-tst-38327': 'TAXI_ML_MODELS_DEPLOY_TESTING',
    'robot-haas-ci': 'HAAS',
    'robot-contest': 'CONTEST-ADMIN',
    'robot-warerobot': 'MARKET',
    'robot-goods': 'GOODS-INDEXER',
}
