import logging
import os.path

from sandbox import common


_CGROUPS_SYS_DIR = "/sys/fs/cgroup"
_CGROUPS_CACHE = {}  # Note: we are not using decorators.memoize here due to unhashable second argument (dict)


def create_cgroup(name, props):
    """Creates cgroup using new sandbox cgroup API"""

    if not name:
        return None

    if name in _CGROUPS_CACHE:
        logging.info("Reuse cgroup {} from cache".format(name))
        return _CGROUPS_CACHE[name]

    if not os.path.isdir(_CGROUPS_SYS_DIR) or os.listdir(_CGROUPS_SYS_DIR) == []:
        raise common.errors.TemporaryError("Cgroups are required on a host with no cgroups. Looking for another.")

    logging.info("Creating cgroup {} with configuration {}".format(name, props))

    control_group = common.os.CGroup(name)
    for subsys_name, subsys_attrs in props.iteritems():
        for attr_name, attr_value in subsys_attrs.iteritems():
            getattr(control_group, subsys_name)[attr_name] = attr_value

    _CGROUPS_CACHE[name] = control_group
    return control_group
