# -*- coding: utf-8 -*-

"""
    Общие фунции для получения имен команд для некоторых утилит на клинетах Sandbox
"""

import sandbox.sandboxsdk.util as sdk_util


def get_make_name(jobs_by_cores=False):
    """
        Возвращает список с именем make команды в зависимости от текущего хоста, на котором выполняется задача
        для freebsd - gmake
        для всего остального - make

        :param jobs_by_cores: добавить в возвращаемый список ключ -j в соответствии с количеством ядер CPU
        :type jobs_by_cores: bool
        :return: список с нужными командами в виде строк
        :rtype: list
    """
    sys_info = sdk_util.system_info()
    make_command_name = 'make'
    if sdk_util.is_arch_compatible('freebsd', sys_info['arch']):
        make_command_name = 'gmake'
    result = [make_command_name]
    if jobs_by_cores:
        result.extend(['-j', str(sys_info['ncpu'])])
    return result
