"""
    SEARCH-1762
"""
import logging

import sandbox.common.types.resource as ctr
from sandbox import sdk2

from sandbox.projects import resource_types
from sandbox.projects.common import file_utils as fu


def patch_cfg(task, initial_cfg_path, patch, patched_cfg_path, cfg_for=""):
    cfg_patcher_res = list(sdk2.Resource.find(
        resource_type=resource_types.RTYSERVER_UTILS_CONFIG_PATCHER,
        state=ctr.State.READY,
        attr_name="branch",
        attr_value="trunk",
    ).limit(1))[0]
    logging.info("Got cfg patcher resource: %s", cfg_patcher_res.id)
    cfg_patcher_path = str(sdk2.ResourceData(cfg_patcher_res).path)
    with sdk2.helpers.ProcessLog(task, logger="patch_{}_cfg".format(cfg_for)) as pl:
        cmd = [cfg_patcher_path, "patch", "--ignore-prefix", initial_cfg_path, patch, patched_cfg_path]
        retcode = sdk2.helpers.subprocess.Popen(cmd, stdout=pl.stdout, stderr=pl.stderr).wait()
        if retcode != 0:
            logging.error("Something went wrong:\n%s", fu.read_lines(str(pl.stderr.path))[-10:])

    patched_cfg = fu.read_file(patched_cfg_path)
    return patched_cfg
