import random

import logging
import requests


def update_nanny_service(nanny, service, yt_state, sandbox_files=None, static_files=None):
    sandbox_files = sandbox_files or []
    static_files = static_files or []

    service_attrs = nanny.get_service_runtime_attrs(service)
    resources = service_attrs['content']['resources']

    resources['sandbox_files'] = _merge_nanny_lists(resources['sandbox_files'], sandbox_files)
    resources['static_files'] = _merge_nanny_lists(resources['static_files'], static_files)

    snapshot_id = nanny.update_service_resources(
        service, {
            'content': resources,
            'comment': '[auto] update {}; yt state -> {}'.format(
                [obj['local_path'] for obj in sandbox_files + static_files],
                yt_state,
            ),
        }
    )['runtime_attrs']['_id']

    return snapshot_id


def _merge_nanny_lists(list1, list2):
    dict1 = {obj['local_path']: obj for obj in list1}
    dict2 = {obj['local_path']: obj for obj in list2}
    dict1.update(dict2)
    return dict1.values()


def build_replicamap(group_prefix, gencfg_tag, build_state, timestamp, task_id):
    """
        @:returns dict
    """

    shards = {}
    replica_map = {
        'meta': {'sandbox_task_id': task_id},
        'shards': shards,
        'config': {
            'generation': build_state,
            'build_state': build_state,
        }
    }

    b = _get_shards(group_prefix + '_BUILD', gencfg_tag)
    x = _get_shards(group_prefix + '_BUILD_X', gencfg_tag)
    nidx = _get_shards(group_prefix + '_NIDX', gencfg_tag)

    d = {}
    for s in set(nidx.keys()):
        d[s] = nidx.get(s, [])

    tiers = set()
    random.seed(228)
    for s, r in b.iteritems():
        parts = s.split('-')
        tiers.add(parts[1])
        shard = parts[2] + '-' + parts[3]

        shards[s.replace('0000000000', timestamp)] = {
            'shard': shard,
            'instances':
                _get_builders('b', r) +
                _get_builders('x', x['none'], min(MAGIC_X_NUMBER, len(x['none']))) +
                _get_builders('d', d.get(s, []))
        }

    assert len(tiers) == 1
    tier = tiers.pop()
    replica_map['config']['tier'] = tier
    slot_size = TIER_BUILD_SIZES.get(tier, 100)
    replica_map['config']['slot_size_gb'] = slot_size

    logging.info('Set slot_size_gb {0} for tier {1}'.format(slot_size, tier))
    return replica_map


def _get_builders(policy, instances, sample_size=None):
    return [{'instance': i, 'policy': policy}
            for i in random.sample(instances, sample_size if sample_size else len(instances))]


def _get_shards(group, tag):
    shards = {}

    r = requests.get(GENCFG_API + '/' + tag + '/searcherlookup/groups/' + group + '/instances')
    if r.status_code == 200:
        for i in r.json()['instances']:
            shards.setdefault(i['shard_name'], [])
            shards[i['shard_name']].append(i['hostname'] + ':' + str(i['port']))

    logging.info('Get {0} instances from group {1}'.format(len(shards), group))
    return shards


TIER_BUILD_SIZES = {'PlatinumTier0': 20, 'WebFreshTier': 160}
MAGIC_X_NUMBER = 5
GENCFG_API = 'http://api.gencfg.yandex-team.ru'
REPLICAMAP_FILENAME = 'replicamap.json'

NANNY_API_URL = 'http://nanny.yandex-team.ru/'

CLUSTERSTATE_URL = 'http://clusterstate.yandex-team.ru'
