class DiffColors(object):
    good = "green"
    neutral = "gray"
    bad = "red"
    uncertain = "orange"


def get_color_diff(diff, max_diff, probability=100):
    """
        Good (green): diff and max_diff have same sign.
        Bad (red): diff and max_diff have different sign.
        Neutral (gray): diff less than max_diff by abs value
        Uncertain (orange): probability less than 95 per cent
        :return: Color from DiffColors
    """
    mark = int(diff / max_diff)
    if not mark:
        return DiffColors.neutral
    elif probability < 95:
        return DiffColors.uncertain
    else:
        return [DiffColors.bad, DiffColors.good][mark < 0]


def color_diff(diff, max_diff=1, round_to=2, probability=100):
    """
        :param diff: Per cent
        :param max_diff: Per cent threshold of coloring into red or green.
                         Can be negative for reversing colors.
        :param round_to: Number of digits after comma
        :param probability: Probability of diff correctness (from t-criteria)
        :return: Colored diff
    """
    if not isinstance(diff, (int, float)):
        return "<strong style='color:Cyan'>{}</strong>".format(diff)
    return "<strong style='color:{}'>{:+} %</strong>".format(
        get_color_diff(diff, float(max_diff), probability), round(diff, round_to)
    )
