# -*- coding: utf-8 -*-

import os
import sys
import tempfile


_WORK_DIR = os.getcwd()
if len(sys.argv) > 1:
    _WORK_DIR = sys.argv[1]


def assert_equal(x, y):
    assert x == y, '"{}" and "{}" must be equal'.format(x, y)


def assert_issubset(x, y):
    assert set(x).issubset(set(y)), '"{}" must be subset of "{}"'.format(x, y)


def read_file(file_name):
    with open(file_name, 'r') as f:
        return f.read()


def assert_string_contains(string, substring):
    assert string.find(substring) != -1, 'Substring "{}" was not found'.format(substring)


def assert_string_not_contains(string, substring):
    assert string.find(substring) == -1, 'Substring "{}" was found'.format(substring)


def assert_directories_equal(path_expected, path_real):
    files_extected = sorted(os.listdir(path_expected))
    files_real = sorted(os.listdir(path_real))
    assert_equal(files_extected, files_real)
    for file_name in files_extected:
        full_path_expected = os.path.join(path_expected, file_name)
        full_path_real = os.path.join(path_real, file_name)
        assert os.path.isdir(full_path_real) and os.path.isdir(full_path_expected) or os.path.isfile(full_path_real) and os.path.isfile(full_path_expected), "File types mismatch"
        if os.path.isdir(full_path_expected):
            assert_directories_equal(os.path.join(path_expected, file_name), os.path.join(path_real, file_name))
        else:
            with open(full_path_expected) as expected_file:
                with open(full_path_real) as real_file:
                    assert expected_file.read() == real_file.read(), "Files {} and {} are not equal".format(full_path_real, full_path_expected)


def make_tmp_dir(debug_prefix=''):
    if debug_prefix and not debug_prefix.endswith('_'):
        debug_prefix += '_'
    return tempfile.mkdtemp(prefix='tmp_dir_' + debug_prefix, dir=_WORK_DIR)
