from __future__ import print_function

import argparse
import json
import logging
import psutil


def memory_usage():
    parser = argparse.ArgumentParser(description="Measure memory usage for process")
    parser.add_argument("-p", "--pid", help="Process pid", type=int)
    opts = parser.parse_args()
    logging.debug("Psutil version = %s", psutil.__version__)
    print(json.dumps(dict(psutil.Process(opts.pid).memory_full_info()._asdict()), indent=2))


if __name__ == '__main__':
    memory_usage()
