from sandbox import sdk2


class DolbilkaResource(sdk2.Resource):
    auto_backup = True
    releasers = ['mvel', 'and42', 'darkk', 'filmih']


class DEXECUTOR_EXECUTABLE(DolbilkaResource):
    """
        Original coroutine based shooting engine
    """
    executable = True
    releasable = True
    any_arch = False
    arcadia_build_path = 'tools/dolbilo/executor/d-executor'


class DNEHER_EXECUTABLE(DolbilkaResource):
    """
        Shooting engine based on neh library (deprecated?)
    """
    executable = True
    releasable = True
    any_arch = False
    arcadia_build_path = 'tools/dolbilo/neher/d-neher'


class DPLANNER_EXECUTABLE(DolbilkaResource):
    """
        Planner - tool to generate shooting plan
    """
    executable = True
    releasable = True
    any_arch = False
    arcadia_build_path = 'tools/dolbilo/planner/d-planner'


class DDUMPER_EXECUTABLE(DolbilkaResource):
    """
        Dumper - tool to obtain shooting stats in text format
    """
    executable = True
    releasable = True
    any_arch = False
    arcadia_build_path = 'tools/dolbilo/dumper/d-dumper'


class DOLBILKA_STPD_QUERIES(sdk2.resource.AbstractResource):
    """
        Plain text queries in stpd format
    """
    auto_backup = True
