#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging
import os


def parse_strelkovsky(borders):
    if not borders:
        return
    slices = borders.split(';')
    slice_from = 0
    for s in slices:
        parts = s.strip().split(':')
        slice_name = parts[0]
        slice_to = int(parts[1])
        yield (slice_name, slice_from, slice_to)
        slice_from = slice_to


def calc_slices_in_binding(model_binding, name):
    """
    Вычислить необходимое значение поля Slices

    :param model_binding: TMXNetInfo binding
    :param name: имя файла с моделью
    :return: необходимое значение поля Slices
    """

    logging.info("Calc Slices for: %s", name)
    borders = list(parse_strelkovsky(model_binding.GetProperty('borders')))
    if borders:
        logging.info("Borders: %s", str(borders))
        return ' '.join('%s[%i;%i)' % b for b in borders)
    used_factors = model_binding.GetProperty('Used factors')
    after_last_f = int(used_factors.split(',')[-1]) + 1 if used_factors else 0
    name = os.path.basename(name)
    if 'Fresh' in name and 'ExtRelev' in name:
        logging.info("Fresh: %i", after_last_f)
        return 'fresh[0;100) web_production[100;%i)' % after_last_f
    else:
        logging.info("WebProduction: %i", after_last_f)
        return 'web_production[0;%i)' % after_last_f
