#!/usr/bin/env python
# -*- coding: utf-8 -*-

import argparse
from distutils.dir_util import copy_tree
import logging
import os

from . import utils


def merge(destination, source, ignore_conflicts=False):
    if not os.path.exists(source):
        return
    conflicts = utils.conflict_files(source, destination)
    if conflicts:
        logging.info("Found conflicts: %s", ", ".join(conflicts))
        if ignore_conflicts:
            for conflict in conflicts:
                logging.info("Remove conflicting files from destination: %s", destination)
                os.remove(os.path.join(destination, conflict))
        else:
            raise utils.ModelsError("There are conflicting files: {0}".format(", ".join(conflicts)))

    copy_tree(source, destination)


def parse_args():
    args = argparse.ArgumentParser(description='Merge models before packing')
    args.add_argument(
        "destination",
        type=str,
        help="path to destination directory",
    )
    args.add_argument(
        "source",
        nargs="+",
        type=str,
        help="path to source files and directories",
    )
    args.add_argument(
        "-v",
        "--verbose",
        action='store_true',
        help="print logs",
    )
    return args.parse_args()


def main():
    args = parse_args()
    logging.basicConfig(
        format='%(levelname)s\t%(message)s',
        level=logging.INFO if args.verbose else logging.WARNING,
    )
    merge(args.destination, args.source)


if __name__ == "__main__":
    main()
