def int_hash(x):
    x = 0xFFFFFFFF & (x + (~(x << 15)))
    x = 0xFFFFFFFF & (x ^ ((x >> 10)))
    x = 0xFFFFFFFF & (x + ((x << 3)))
    x = 0xFFFFFFFF & (x ^ ((x >> 6)))
    x = 0xFFFFFFFF & (x + (~(x << 11)))
    x = 0xFFFFFFFF & (x ^ ((x >> 16)))
    return x


def combine_two_hashes(h1, h2):
    return int_hash(h1) ^ h2


def combine_hashes(hashes):
    if not hashes:
        return 0
    hashes.sort()
    h = hashes.pop()
    for _ in hashes:
        h = combine_two_hashes(h, _)
    return h


def get_hash(value):
    if isinstance(value, list):
        return combine_hashes([get_hash(x) for x in value])
    elif isinstance(value, dict):
        return combine_hashes([combine_two_hashes(get_hash(k), get_hash(value[k])) for k in value])
    else:
        return hash(value)
