# -*- coding: utf-8 -*-

import logging

from sandbox.sandboxsdk import process


def distmove(binary, source, destination, source_stream, destination_stream=None, age=10000, count=None):
    if destination_stream is None:
        destination_stream = source_stream
    args = [
        '-i', source_stream,
        '-o', destination_stream,
        '-a', str(age)
    ]
    if count is not None:
        args += [
            '-c', str(count)
        ]
    args += [
        source,
        destination
    ]

    logging.info("distmove {} {}".format(source, destination))
    return process.run_process(
        [binary] + args,
        wait=True,
        log_prefix='distcl_move',
        shell=False
    )
