from sandbox.sandboxsdk.parameters import ResourceSelector, LastReleasedResource, SandboxIntegerParameter
from sandbox.sandboxsdk.parameters import SandboxBoolParameter, SandboxStringParameter
from sandbox.projects.common.search.components import DefaultMiddlesearchParams

from sandbox.projects import resource_types


FRESHNESS_MODE = "freshness"
SAMOHOD_MODE = "samohod"

MiddlesearchParamNames = tuple(param.name for param in DefaultMiddlesearchParams.params)


class Binary(ResourceSelector):
    name = 'basesearch_executable_resource_id'
    description = 'Executable'
    resource_type = [
        resource_types.RTYSERVER_EXECUTABLE,
    ]
    group = 'Fusion params'
    required = True
    group = "Candidate stand configuration"


class KiwiTriggers(ResourceSelector):
    name = 'kiwi_triggers_resource_id'
    description = 'Kiwi triggers'
    resource_type = [resource_types.KWTRIGGER_FOLDER]
    required = True
    group = "Candidate stand configuration"


class MaxDocs(SandboxIntegerParameter):
    name = "db_max_docs"
    description = 'Maximum number of documents in memory index (surpassing means creating disk index)'
    default_value = 10000
    group = "Feeding docs params"


class DumpParameter(LastReleasedResource):
    name = 'index_reqs_dump_resource_id'
    description = 'IndexRequests dump'
    resource_type = [resource_types.INDEX_REQUESTS_DUMP]
    group = "Feeding docs params"


class IndexerPackage(ResourceSelector):
    name = 'indexer_package_resource_id'
    description = 'Alternative Indexer package'
    resource_type = [resource_types.TEAMCITY_RESOURCE]
    required = True
    group = "Additional params"


class UseMiddlesearch(SandboxBoolParameter):
    name = 'use_middlesearch'
    description = 'Use middlesearch above the fusion stand'
    group = "Middlesearch Params"
    default_value = False
    sub_fields = {
        "true": MiddlesearchParamNames
    }


class SkipUserdata(SandboxBoolParameter):
    name = 'skip_userdata'
    description = 'Skip userdata downloading'
    group = "Additional params"
    default_value = False


class UserdataLong(LastReleasedResource):
    name = "userdata_long"
    description = "Userdata Long resource"
    resource_type = resource_types.FUSION_USERDATA_LONG
    group = "Userdata"


class UserdataFast(LastReleasedResource):
    name = "userdata_fast"
    description = "Userdata Long resource"
    resource_type = resource_types.FUSION_USERDATA_FAST
    group = "Userdata"


class UserdataLongFreshFilter(LastReleasedResource):
    name = "userdata_long_freshfilter"
    description = "Userdata Long resource"
    resource_type = resource_types.FUSION_USERDATA_LONG_FRESHFILTER
    group = "Userdata"


class ExternalData(LastReleasedResource):
    name = "external_data"
    description = "External data resource"
    resource_type = resource_types.FUSION_EXTERNAL_DATA
    group = "Userdata"


class TimeToLive(SandboxIntegerParameter):
    name = "time_to_live"
    description = 'Time to live before index merge (and dumping to disk)'
    default_value = None
    group = "Feeding docs params"


class ExternalFactorNamesResource(LastReleasedResource):
    name = "factor_names_resource"
    description = "Select external factor names dump (in case of problems in tasks in question)"
    resource_type = [resource_types.OTHER_RESOURCE]
    group = "Additional params"


UserdataParams = (UserdataFast, UserdataLong, UserdataLongFreshFilter)
UserdataParamNames = tuple(param.name for param in UserdataParams)


class UseExternalUserdata(SandboxBoolParameter):
    name = 'use_external_userdata'
    group = 'Userdata'
    description = 'Use external userdata'
    default_value = False
    sub_fields = {
        "true": UserdataParamNames
    }


class VerifyMergeStats(SandboxBoolParameter):
    name = 'verify_merge_stats'
    group = 'Additional params'
    description = 'Verify merge stats (fail if merge failed)'
    default_value = False


class RunMode(SandboxStringParameter):
    name = 'run_mode'
    description = 'Fusion mode (configs)'
    choices = [
        ("FRESHNESS", FRESHNESS_MODE),
        ("SAMOHOD", SAMOHOD_MODE),
    ]
    default_value = FRESHNESS_MODE


class SaveDb(SandboxBoolParameter):
    name = 'save_db'
    group = 'Additional params'
    description = 'Save created database for further reuse in tests'
    default_value = False


class PatchQueries(SandboxStringParameter):
    name = 'patch_queries'
    description = 'Add following substring to every request ' \
                  '(if "_AllFactors" is in the string, &haha=da is removed from the query)'
    default_value = ""


fusion_input_params = (
    Binary,
    KiwiTriggers,
    DumpParameter,
    MaxDocs,
    IndexerPackage)


def get_query_patcher(substring):
    def patch(query):
        query += substring
        if "_AllFactors" in substring:
            # otherwise it doesn't make sense
            query = query.replace("&haha=da", "")
        return query

    return patch
