# -*- coding: utf-8 -*-

from sandbox.projects.common.search import response_patcher as rpatch


def response_patcher(response):
    """
        Convert scheme json to tree if necessary,
        remove unstable fusion-specific data
    """
    rpatch.convert_scheme_to_tree(response)
    searchProp = response._nodes.get("SearcherProp")
    if searchProp:
        fixed_sp = []
        for sp in searchProp:
            key = sp.GetPropValue("Key")
            if key != "BaseTimestamp":
                fixed_sp.append(sp)
        response._nodes["SearcherProp"] = fixed_sp
