import os
import sys
import logging


from sandbox.projects import resource_types
from sandbox.sandboxsdk import process
from sandbox.sandboxsdk.channel import channel

from sandbox.projects.common import apihelpers
from sandbox.sandboxsdk.paths import make_folder


def get_stand_script(path):
    make_folder(path)
    resoure_id = apihelpers.get_last_released_resource(resource_types.LOCAL_FUSION_RUNNER).id
    logging.info("Using local fusion launcher resource: %s" % resoure_id)
    resource_path = channel.task.sync_resource(resoure_id)
    process.run_process(
        [
            "tar", "-xf", resource_path, "-C", path
        ],
        wait=True,
        log_prefix='unpack_stand',
        shell=False,
    )
    return os.path.abspath(os.path.join(path, "local_fusion"))


def get_external_data(path):
    stand_path = get_stand_script(path)
    getter_path = os.path.join(stand_path, "search", "fusion", "tests", "stand", "get_data.py")
    process.run_process([sys.executable, getter_path, path], wait=True, log_prefix="get_external_data", shell=False)
    return os.path.join(path, "external_files", "current")
