import os
import re
import json
import urllib2
import requests
import logging

from sandbox.projects.common import error_handlers as eh

DOC_SIZE_REGEXP = re.compile(r"Fusion_DiskIndex_DocumentSizeAvg\W+total=\W+(\d+),")


def fetch(address):
    try:
        return urllib2.urlopen(address).read()
    except urllib2.URLError as exc:
        eh.check_failed(
            "fusion.tools::fetch: Failed to fetch '{}'. Reason: {}".format(address, exc))


def get_avg_doc_size(controller_port, host="127.0.0.1"):
    address = "http://{}:{}/metric".format(host, controller_port)
    logging.info("Getting stats from %s" % address)
    stats = fetch(address)
    logging.debug("\nObtained stats:\n%s\n" % stats)
    found = DOC_SIZE_REGEXP.search(stats)
    if found:
        try:
            return int(found.groups()[0])
        except Exception as e:
            logging.error("Failed to get avg doc size: {}".format(e))


def fetch_stats(controller_port, host="127.0.0.1"):
    address_template = "http://{host}:{port}/status"
    address = address_template.format(host=host, port=controller_port)
    try:
        response = urllib2.urlopen(address)
        return response.read()
    except Exception as e:
        logging.exception("Controller is not available on %s: %s", address, e)
        return None


def get_stats(controller_port, host="127.0.0.1"):
    metric_re = re.compile(r"(?P<name>\S*)\s*:\s*(?P<value>\S*)")
    stats = fetch_stats(controller_port, host)
    parsed_stats = {}
    if stats:
        for line in stats.split(os.linesep):
            parsed = metric_re.search(line)
            if parsed:
                name = parsed.group("name").lower()
                value = parsed.group("value").lower()
                try:
                    parsed_stats[name] = int(value)
                except ValueError:
                    parsed_stats[name] = value
    logging.debug(parsed_stats)
    return parsed_stats


def get_info_server(controller_port, host="localhost"):
    raw = fetch("http://{}:{}/?command=get_info_server".format(host, controller_port))
    return json.loads(raw)


def run_rtyserver_command(host, port, cmd, t=10):
    address_template = "http://{host}:{port}/?command={cmd}"
    address = address_template.format(host=host, port=port, cmd=cmd)
    result = {}
    try:
        result = requests.get(address, verify=False, timeout=t).json()
    except Exception as e:
        logging.exception("Controller is not available on %s: %s", address, e)
    return result


def verify_merge_stats(controller_port, host="127.0.0.1"):
    stats = get_stats(controller_port, host)
    assert stats['active_disk_index_count'] > 0
    assert stats['index_merge_failed_count'] == 0
    assert stats['index_merge_last_elapsed_time'] != 0
