import logging
import os

import sandbox.common.types.client as ctc
from sandbox.projects import resource_types
from sandbox.sandboxsdk import svn, task, process
from sandbox.sandboxsdk.sandboxapi import Sandbox
from sandbox.projects.common.gencfg.utils import get_venv_id


class BaseVenvBundleTask(task.SandboxTask):
    """ Task builds bundle with venv and py program """
    client_tags = ctc.Tag.Group.LINUX

    def on_execute(self):
        reqs = self.get_requirements_url()
        venv_id = get_venv_id(reqs, self)
        logging.info('calculated venv resource id: %s', venv_id)

        venv_res = Sandbox().get_resource(venv_id)
        url = venv_res.url or venv_res.proxy_url

        process.run_process(['sky', 'get', url], log_prefix='sky get', shell=True)
        process.run_process(['tar', 'xvzf', url.split('/')[-1]], log_prefix='untar', shell=True)
        src_dir = export_src_dir(self.get_src_url())

        process.run_process(['tar', 'czf', 'bundle.tar.gz', 'virtualenv', src_dir], log_prefix='tar', shell=True)

        resource = self.create_resource(
            description='bundle with venv and src',
            resource_path='bundle.tar.gz',
            resource_type=str(resource_types.CLUSTERSTATE_BUNDLE),
            arch='linux'
        )

        self.ctx['RESOURCES'] = {'resources': [resource.id]}

    def get_requirements_url(self):
        return svn.Arcadia.trunk_url(path=os.path.join(self.project_path, 'requirements.txt'))

    def get_src_url(self):
        return svn.Arcadia.trunk_url(path=os.path.join(self.project_path, 'src'))


def export_src_dir(src_url):
    dir_name = src_url.split('/')[-1]
    svn.Arcadia.export(src_url, dir_name)
    return dir_name
