import xml.dom.minidom
import xml.etree.ElementTree as ET

from six import text_type


class IndexerConfig(object):
    def __init__(self):
        self.files = {}
        self.directories = {}
        self.options = {}
        self.sources = []

    def dump(self):
        sections = [
            ('Files', self.files),
            ('Directories', self.directories),
            ('Options', self.options),
        ] + [
            ('Source', source) for source in self.sources
        ]

        root = ET.Element('Config')
        for name, data in sections:
            node = ET.SubElement(root, name)
            for k, v in data.iteritems():
                ET.SubElement(node, k).text = text_type(v)

        xml_data = ET.tostring(root, 'utf-8')
        reparsed = xml.dom.minidom.parseString(xml_data)
        return reparsed.toprettyxml()
