import re
import codecs

from collections import defaultdict


def load_reqans_log(file_name):
    with codecs.open(file_name, 'r', 'utf-8') as f:
        text = f.read()

    recs = text.split('REQANS-END')

    ret = defaultdict(lambda: '')
    r_find_parent = re.compile(r'parent_reqid=(\w+)')

    re_start_cut = [
        ('REQANS-START', ''),
    ]

    re_cuts = [
        (r'ts=[^@]+', 'ts='),
        (r't_tot=[^@]+', 't_tot='),
        (r'reqid=[^@]+', 'reqid='),
        (r'serpid=[^@]+', 'serpid='),
    ]

    for rec in recs:
        rec = rec.strip()

        for re_, sub in re_start_cut:
            rec = re.sub(re_, sub, rec)

        rec = rec.strip()

        if not rec:
            continue

        m = r_find_parent.search(rec)
        if not m:
            raise Exception('Not found parent_reqid in reqans log.')
        parent_reqid = m.group(1)

        for re_, sub in re_cuts:
            rec = re.sub(re_, sub, rec)

        ret[parent_reqid] = rec

    return ret
