# -*- coding: utf-8 -*-
from sandbox import sdk2

from collections import OrderedDict

import sandbox.projects.resource_types as rt
from sandbox.projects.geosearch.resource_types import MAPS_DATABASE_FAST_FEATURES_SHARD, \
    MAPS_DATABASE_FAST_FEATURES_SHARDED, GEOSEARCH_DYNAMIC_FORMULA


def get_addrs_basesearch_params(param_suffix=''):
    result = OrderedDict()
    result['geobasesearch_executable_resource_id%s' % param_suffix] = sdk2.parameters.Resource(
        'GeoBasesearch executable', resource_type=rt.GEOBASESEARCH_EXECUTABLE, required=True)
    result['geobasesearch_config_resource_id%s' % param_suffix] = sdk2.parameters.Resource(
        'GeoBasesearch config', resource_type=[rt.GEOBASESEARCH_CONFIG, rt.MAPS_SEARCH_CONFIG_BASE], required=True)
    result['shard_rbtorrent%s' % param_suffix] = sdk2.parameters.String('Addrs Basesearch shard rbtorrent', required=True)
    result['maps_search_advert_db_resource_id%s' % param_suffix] = sdk2.parameters.Resource(
        'Advert database', resource_type=rt.MAPS_DATABASE_ADVERT, required=True)
    result['fast_features_sharded_resource_id%s' % param_suffix] = sdk2.parameters.Resource(
        'Fast features shard', resource_type=MAPS_DATABASE_FAST_FEATURES_SHARD)
    result['fast_features_all_shards_resource_id%s' % param_suffix] = sdk2.parameters.Resource(
        'Fast features all shards', resource_type=MAPS_DATABASE_FAST_FEATURES_SHARDED)
    result['filter_stat_resource_id%s' % param_suffix] = sdk2.parameters.Resource(
        'filter_stat.bin', resource_type=rt.BUSINESS_COMPUTED_FILTERS, required=True)
    result['formulas_dir_resource_id%s' % param_suffix] = sdk2.parameters.Resource(
        'Directory with ranking formulas', resource_type=rt.MAPS_RANKING_MODELS, required=False)
    result['dynamic_formula_resource_id%s' % param_suffix] = sdk2.parameters.Resource(
        'Dynamic ranking formulas', resource_type=GEOSEARCH_DYNAMIC_FORMULA, required=False)
    result['custom_plan_id%s' % param_suffix] = sdk2.parameters.Resource(
        'Custom plan (overrides general plan)', resource_type=rt.BASESEARCH_PLAN, required=False)
    return result
