# -*- coding: utf-8 -*-
import logging
import requests
import json


class StartrekClient(object):
    def __init__(self, oauth_token):
        self.url = 'https://st-api.yandex-team.ru/v2/'
        self.token = oauth_token
        self.session = requests.Session()
        self.session.headers['Authorization'] = 'OAuth {}'.format(self.token)
        self.session.headers['Content-Type'] = 'application/json'

    def create_task(self, issue_dict):
        url = '{base_url}issues'.format(base_url=self.url)
        try:
            request = self.session.post(url, json.dumps(issue_dict), verify=False)
            if request.ok:
                response = request.json()
                return response['key']
            else:
                logging.info('Error on creating task in %s' % issue_dict.get('queue'))
                logging.info(request.json())
        except Exception as err:
            logging.info('Error creating startrek task')
            logging.info('Details: %s' % err)

    def add_comment(self, issue, comment_text):
        url = '{base_url}issues/{issue}/comments'.format(base_url=self.url,
                                                          issue=issue)
        data = {'text': comment_text}
        try:
            request = self.session.post(url, json.dumps(data), verify=False)
            if request.ok:
                response = request.json()
                return response.get('id')
            else:
                logging.info('Error on adding comment to %s task' % issue)
                logging.info(request.json())
        except Exception as err:
            logging.info('Error writing comment to %s task' % issue)
            logging.info('Details: %s' % err)

    def add_followers(self, issue, followers):
        url = '{base_url}issues/{issue}'.format(base_url=self.url,
                                                          issue=issue)
        data = {'followers': [{'id': follower} for follower in followers]}
        try:
            request = self.session.patch(url, json.dumps(data), verify=False)
            if request.ok:
                response = request.json()
                return response.get('id')
            else:
                logging.info('Error on adding comment to %s task' % issue)
                logging.info(request.json())
        except Exception as err:
            logging.info('Error adding follower to %s' % issue)
            logging.info('Details: %s' % err)

    def add_tag(self, issue, tag):
        url = '{base_url}issues/{issue}'.format(base_url=self.url,
                                                          issue=issue)
        data = {'tags': {'add': tag}}
        try:
            request = self.session.patch(url, json.dumps(data), verify=False)
            if request.ok:
                response = request.json()
                return response.get('id')
            else:
                logging.info('Error on adding comment to %s task' % issue)
                logging.info(request.json())
        except Exception as err:
            logging.info('Error adding follower to %s' % issue)
            logging.info('Details: %s' % err)

    def add_tags(self, issue, tags):
        for tag in tags:
            self.add_tag(issue, tag)
