from sandbox.projects.common.geosearch.search_components import get_addrs_basesearch_params
from sandbox.projects.common.geosearch.search_components import get_addrs_basesearch_business
from sandbox.projects.common.search.basesearch import task as search_task


GEOBASESEARCH_PARAMS = get_addrs_basesearch_params()


class AddrsBasesearchTask(search_task.BasesearchComponentTask):

    required_ram = 96 * 1024
    execution_space = 100 * 1024

    basesearch_common_parameters = \
        GEOBASESEARCH_PARAMS.params + \
        search_task.BasesearchComponentTask.basesearch_common_parameters

    basesearch_input_parameters = \
        basesearch_common_parameters + \
        search_task.BasesearchComponentTask.basesearch_supermind_parameters

    def on_enqueue(self):
        search_task.BasesearchComponentTask.on_enqueue(self)
        # search_settings.ImagesSettings.ensure_search_database(
        # self.ctx,
        # self._get_queries_parameter(),
        # BASESEARCH_PARAMS.Database
        # )
        # self.execution_space = search_settings.ImagesSettings.basesearch_database_size(
        # self.ctx,
        # BASESEARCH_PARAMS.Database
        # ) + 20 * 1024

    def _get_addrsbasesearch(self):
        return get_addrs_basesearch_business(self.ctx, params=GEOBASESEARCH_PARAMS)

    def _get_queries_parameter(self):
        raise NotImplementedError()
