# -*- coding: utf-8 -*-

import shutil
import tarfile
import logging
import os
from urlparse import urlparse

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.sandboxsdk.paths import make_folder

from sandbox.projects.common import apihelpers


class UpdateGeoEnvironmentBase(SandboxTask):

    def initCtx(self):
        self.ctx['__hosts_chooser_os'] = 'linux_ubuntu_10.04_lucid'

    input_parameters = []

    def _download_arch(
        self, url, create_resource=False, resource_type=None, resource_descr=None
    ):
        remote_path = urlparse(url).path
        remote_file_name = os.path.split(remote_path)[-1]
        dest_path = os.path.join(self.abs_path(), remote_file_name)
        self.remote_copy(url, dest_path)
        if not create_resource:
            return dest_path
        else:
            res = self._create_resource(
                resource_descr or self.descr,
                remote_file_name,
                resource_type,
                arch='any')
            return res

    def _get_res_with_attr(self, res_type, attr_name):
        res = apihelpers.get_last_resource_with_attribute(
            resource_type=res_type,
            attribute_name=attr_name)
        if not res:
            raise SandboxTaskFailureError('Last resource {0} with type {1} not found'.format(res_type, attr_name))
        return res

    def _unpack_to_resource(self, arch_path, name, type_after_unpack, resource_descr=None):
        unpack_dir = make_folder(os.path.join(self.abs_path(), 'unpacked_%s' % name))
        logging.info('Extract tar %s to %s' % (arch_path, unpack_dir))
        tarfile.open(arch_path, "r:gz").extractall(unpack_dir)

        out_res = self.create_resource(
            resource_descr or self.descr,
            name,
            type_after_unpack,
            arch='any'
        )

        d = os.listdir(unpack_dir)[0]
        d = os.path.join(unpack_dir, d)
        if not os.path.isdir(d):
            raise SandboxTaskFailureError('Must be one directory in archive, but found %s' % d)
        files_count = len([f for f in os.listdir(d) if os.path.isfile(os.path.join(d, f))])
        logging.info('Files count: ' + str(files_count))
        if files_count > 1:
            logging.info('Moving from {0} to {1}'.format(d, out_res.path))
            if os.path.exists(out_res.path):
                shutil.rmtree(out_res.path)
            shutil.move(d, out_res.path)
        else:
            f = os.listdir(d)[0]
            src = os.path.join(d, f)
            logging.info('Moving file from {0} to {1}'.format(src, out_res.path))
            shutil.move(src, out_res.path)
        return out_res
