# -*- coding: utf-8 -*-
from sandbox import sdk2


def make_parameters_cls(parameters_dict):
    '''
    Creates Parameters class inherited from sdk2.Task.Parameters from OrderedDict.
    '''
    data = {}
    names = []

    for name, parameter in parameters_dict.iteritems():
        data[name] = parameter
        names.append(name)

    data['__names__'] = names
    return type('Parameters', (sdk2.Task.Parameters,), data)


def create_parameters_group(parameters_dict, *args, **kwargs):
    '''
    Create parameters group from OrderedDict.
    '''
    group = sdk2.parameters.Group(*args, **kwargs)
    group.__locals__ = {}
    group.__names__ = []
    for name, value in parameters_dict.iteritems():
        group.__locals__[name] = value
        group.__names__.append(name)
    return group


def chop_group_suffix(params, group_name, suffix):
    '''
    Get all parameters from a group and chop suffix from their name.

    Return dictionary with values.
    '''

    result = {}
    for name in getattr(type(params), group_name).names:
        if not name.endswith(suffix):
            raise Exception('Found group key %s which doesn\'t ends with suffix %s' % (name, suffix))
        result[name[:-len(suffix)]] = getattr(params, name)
    return result
