import logging

import sandbox.projects.release_machine.core.const as rm_const


LOGGER = logging.getLogger(__name__)


def get_svn_revision_from_gsid(gsid):
    LOGGER.debug("Try to get svn revision from GSID: %s", gsid)
    if gsid:
        svn_info = rm_const.GSID_SVN_RE.search(gsid)
        if svn_info:
            svn_revision = svn_info.group("svn_revision")
            LOGGER.debug("Got svn_revision = %s", svn_revision)
            return svn_revision
    return ""


def get_job_name_from_gsid(gsid):
    LOGGER.debug("Try to get job name from GSID: %s", gsid)
    if gsid:
        te_info = rm_const.GSID_TE_RE.search(gsid)
        if te_info:
            job_name = te_info.group("job_name")
            LOGGER.debug("Got job_name = %s", job_name)
            return job_name
    return ""


def get_testenv_database_from_gsid(gsid):
    LOGGER.debug("Try to get testenv database from GSID: %s", gsid)
    if gsid:
        te_info = rm_const.GSID_TE_RE.search(gsid)
        if te_info:
            db_name = te_info.group("db_name")
            LOGGER.debug("Got db_name = %s", db_name)
            return db_name
    return ""
