import os
import sys
import imp


class SysPathAppender(object):
    def __init__(self, paths):
        self.paths = paths

    def __enter__(self):
        self.sys_path_saved = sys.path
        sys.path = sys.path + self.paths

    def __exit__(self, exc_type, exc_value, traceback):
        sys.path = self.sys_path_saved


def import_path(path, append_sys_path=[]):
    with SysPathAppender(append_sys_path):
        base = os.path.basename(path)
        (name, ext) = os.path.splitext(base)
        m = imp.load_source(name, path)
        return m


if __name__ == "__main__":
    m = import_path(sys.argv[1], sys.argv[2:])
    print("loaded module {}".format(m))
    print("module contents: {}".format(dir(m)))
