# coding: utf-8

from sandbox import sdk2
import sandbox.common.types.task as ctt
from sandbox.common.types.task import ReleaseStatus


class ReleaseGivenTask(sdk2.Task):
    """
        Mark given task as released
    """
    class Parameters(sdk2.Task.Parameters):
        task = sdk2.parameters.Task("Task to release", required=True)
        type = sdk2.parameters.String("Release type status", default=ReleaseStatus.STABLE)
        subject = sdk2.parameters.String("Release message subject", default="Release")
        wait_task = sdk2.parameters.Bool("Wait task before release", default=True)

    def on_execute(self):
        task = self.Parameters.task

        if self.Parameters.wait_task:
            task_list = [task]
            sdk2.WaitTask(task_list, ctt.Status.Group.FINISH, wait_all=True)

        if task.status not in ctt.Status.Group.SUCCEED:
            raise sdk2.TaskFailure('Can not release unsuccessful task {}, status {}'.format(task.id, task.status))

        self.set_info('Create release for task {}'.format(task.id))

        self.server.release(
            task_id=task.id,
            type=self.Parameters.type,
            subject=self.Parameters.subject
        )
