import os
import logging

from sandbox.projects.common.testenv import xml_to_json
from sandbox.common.errors import TaskFailure
from sandbox.projects.common.infra import ResourceManager as RM
from sandbox import sdk2


def xunit_on_enqueue(task, basedir=None, attrs={}):
    json = RM.create_resource(task,
                              os.path.join(basedir, 'result2.json'),
                              'TEST_ENVIRONMENT_JSON_V2',
                              'testenv_results',
                              attrs, False)
    logs = RM.create_resource(task,
                              os.path.join(basedir, 'metatest_logs_v2'),
                              'TEST_ENVIRONMENT_METATEST_LOGS',
                              'testenv_result_logs',
                              attrs, False)
    return (json, logs)


def xunit_find_convert(task, json_res, logs_res, testenv_job='', basedir='', pattern='**/*.xml'):
    xml_files_p = task.path(basedir).glob(pattern)
    if not xml_files_p:
        task.on_exception(TaskFailure("Cant find xml files at :%s" % basedir))
        return

    xml_files = [str(f) for f in xml_files_p]
    logging.debug('Dump xml_list(%s) %s', type(xml_files), xml_files)

    data = sdk2.ResourceData(logs_res)
    data.path.mkdir(0o755, parents=True, exist_ok=True)
    xml_to_json.convert_v2(xml_files, None, str(json_res.path), str(logs_res.path),
                           logs_res.id, testenv_job, True)
