# -*- coding: utf-8 -*-
import logging
import requests

from sandbox import sdk2
from sandbox.sandboxsdk import errors
from sandbox.projects.common.build.YaMake2 import YaMake2
import sandbox.projects.common.build.parameters as build_parameters
import sandbox.projects.common.constants as consts

TESTING_URL = 'http://internal.daas-backend-int.locdoc-test.yandex.net/v1/projects/{}/deploy'
PRODUCTION_URL = 'http://internal.daas-backend-int.yandex.net/v1/projects/{}/deploy'


class YaMakeDAAS(YaMake2):
    """
        Build documentation via YaMake2 and upload it to DAAS server
    """

    class Parameters(YaMake2.Parameters):
        use_aapi_fuse = build_parameters.UseArcadiaApiFuse(default_value=True)
        aapi_fallback = build_parameters.AllowArcadiaApiFallback(default_value=True)
        build_system = build_parameters.BuildSystem(default_value=consts.SEMI_DISTBUILD_BUILD_SYSTEM)
        daas_test_project = sdk2.parameters.String('DAAS test project ID')
        daas_prod_project = sdk2.parameters.String('DAAS production project ID')
        daas_vault_owner = sdk2.parameters.String("Vault owner of daas secret")
        daas_vault_key_name = sdk2.parameters.String("Vault key name of daas token", default="DAAS_TOKEN")

    def do_deploy_daas(self):
        for name, resource_id in self.Context.ap_packs.iteritems():
            logging.debug('walk paks: %s id:%s', name, resource_id)

        for name, resource_id in self.Context.ap_packs.iteritems():
            resource = sdk2.Resource.find(id=resource_id).first()
            logging.debug('walk resources: %s id:%s res:%s', name, resource_id, resource)
            docs_path = str(sdk2.ResourceData(resource).path)

        if self.test_project:
            self.do_upload(TESTING_URL.format(self.test_project), docs_path)
        if self.prod_project:
            self.do_upload(PRODUCTION_URL.format(self.prod_project), docs_path)

    def do_upload(self, url, docs_path):
        with open(docs_path, 'rb') as docs:
            response = requests.post(url,
                                     files={'archive': docs},
                                     headers={"Authorization": "OAuth {}".format(self.daas_token)})
            self.set_info('POST url:{}, archive:{}, response:{}'.format(url, docs_path, str(response)))
            response.raise_for_status()
        pass

    # def on_enqueue(self):
    #     logging.debug("Enter: on_enqueue")
    #     logging.debug("self.Parameters.daas_test_project: %s", self.Parameters.daas_test_project)
    #     logging.debug("self.Parameters.daas_prod_project: %s", self.Parameters.daas_prod_project)
    #
    #     if not self.Parameters.result_single_file:
    #         logging.info("Force set result_single_file=true")
    #         self.Parameters.result_single_file = True
    #     YaMake2.on_enqueue(self)

    def on_execute(self):
        logging.debug("Enter: on_execute")
        logging.debug("self.Parameters.daas_test_project: %s", self.Parameters.daas_test_project)
        logging.debug("self.Parameters.daas_prod_project: %s", self.Parameters.daas_prod_project)

        self.test_project = self.Parameters.daas_test_project
        self.prod_project = self.Parameters.daas_prod_project
        logging.debug("self.test_project: %s", self.test_project)
        logging.debug("self.prod_project: %s", self.prod_project)

        if not self.test_project and not self.prod_project:
            raise errors.SandboxTaskFailureError('DAAS project not defined, at least daas_test_project or daas_prod_project should not be empty')

        vault_owner = self.owner
        if self.Parameters.daas_vault_owner:
            vault_owner = self.Parameters.daas_vault_owner

        logging.debug('get_vault owner:%s key_name:%s', vault_owner, self.Parameters.daas_vault_key_name)
        self.daas_token = sdk2.Vault.data(vault_owner, self.Parameters.daas_vault_key_name)
        if not self.daas_token:
            logging.info('Fail to get vault token')
            raise errors.SandboxTaskFailureError('Fail to get vault_vault, seed logs')

        YaMake2.on_execute(self)
        self.do_deploy_daas()
