from sandbox import sdk2
from sandbox.common.errors import TaskFailure
from sandbox.projects.common.infra.ExecScriptBase import ExecScriptBase
from sandbox.projects.common.infra import ResourceManager as RM
from sandbox.projects.common.infra import Xunit2TestenvReporter as XU
from sandbox.projects.common.infra import resource_types  # noqa
from sandbox.projects.common.infra import ReleaseGivenTask  # noqa


class ExecScript(ExecScriptBase):

    class Requirements(ExecScriptBase.Requirements):
        pass

    class Parameters(ExecScriptBase.Parameters):
        fail_fast = sdk2.parameters.Bool('Fail on first error', default=False)
        out_resource_list = RM.make_reslist_parameter()
        out_resource_cfg = sdk2.parameters.String('Resource manifest file or directory with similar syntax as out_resource_list')
        out_resource_cfg_pattern = sdk2.parameters.String('Resource manifest file pattern', default='**/*.json')
        generic_attrs = sdk2.parameters.Dict('Common attributes assigned to resources saved', default={'ttl': 14})
        xunit_report_dir = sdk2.parameters.String('Directory to find xunit/junit results', required=False)
        xunit_report_pattern = sdk2.parameters.String('Xunit result pattern', required=False,
                                                      default='**/*.xml')

    class Context(sdk2.Task.Context):
        fail_fast = True
        exceptions = False
        git_repo_head = None

    def on_exception(self, e):
        if self.Context.fail_fast:
            raise e
        else:
            self.set_info('Delay exception %s' % str(e))
            self.Context.exceptions = True

    def get_workspace(self):
        return super(ExecScript, self).get_workspace()

    def do_execute(self):
        ExecScriptBase.Context.out_resource_list = []
        basedir = str(self.get_workspace())
        if self.Parameters.xunit_report_dir:
            (x_res, x_log) = XU.xunit_on_enqueue(self, basedir, self.Parameters.generic_attrs)

        # Fail fast if out_resource_list is not well formed
        if self.Parameters.out_resource_list:
            ExecScriptBase.Context.out_resource_list = RM.validate_resource_list(self, self.Parameters.out_resource_list)
        self.Context.fail_fast = self.Parameters.fail_fast

        ExecScriptBase.on_execute(self)

        # Collect custom resource
        if ExecScriptBase.Context.out_resource_list:
            RM.collect_resource_list(self, ExecScriptBase.Context.out_resource_list, basedir, True)
        if self.Parameters.out_resource_cfg:
            RM.collect_resources_from_manifest(self, self.Parameters.out_resource_cfg, basedir,
                                               self.Parameters.out_resource_cfg_pattern)
        # Collect Xunit results
        if self.Parameters.xunit_report_dir:
            testenv_job = getattr(self.Context, 'testenv_job')
            XU.xunit_find_convert(self, x_res, x_log, testenv_job, basedir,
                                  self.Parameters.xunit_report_pattern)

    def on_execute(self):
        self.do_execute()
        if self.Context.exceptions:
            raise TaskFailure('FORCE_FAILURE: Delayed exceptions found, see logs above')
