from sandbox import sdk2
from sandbox.projects.common.infra import ExecScript

from sandbox.projects.sandbox.resources import LXC_CONTAINER
import sandbox.common.types.misc as ctm


class ExecScriptLXC(ExecScript):
    """
    Exec shell script in given container
    """

    class Requirements(ExecScript.Requirements):
        disk_space = 5 * 1024
        # Required for containers with docker, because most docker-registries are ipv4 only
        dns = ctm.DnsType.DNS64

    class Parameters(ExecScript.Parameters):
        container = sdk2.parameters.Container(
            "LXC Container resource to use",
            resource_type=LXC_CONTAINER,
            required=True,
            default='856640615'
        )
        privileged = sdk2.parameters.Bool("You will be root inside LXC")

    def on_save(self):
        super(ExecScript, self).on_save()

        if self.Parameters.privileged:
            self.Requirements.privileged = True
