# coding: utf-8
from sandbox import sdk2


class DockerImage(sdk2.Resource):
    """
    Docker image resource can be imported via: docker load {resource}
    """
    __default_attribute__ = sdk2.parameters.String

    auto_backup = True
    releasable = True


class LXC_SANDBOX_IMAGE_WITH_DOCKER(sdk2.Resource):
    """
    LXC image with docker inside
    """
    __default_attribute__ = sdk2.parameters.String

    auto_backup = True
    releasable = True
    ttl = 360


class KVM_TOOL(sdk2.Resource):
    """
    KVMTool static binary, used here: infra/kernel/tools/lkvm, builds from external git repo
    """
    releasable = True
    auto_backup = True
    executable = True


class LINUX_KERNEL_IMAGE(sdk2.Resource):
    """
    Linux kernel image, used here: infra/kernel
    """
    releasable = True
    auto_backup = True


class LINUX_INITRD(sdk2.Resource):
    """
    Linux init ramdisk image, used here: infra/kernel
    """
    releasable = True
    auto_backup = True


class BUSYBOX_BINARY(sdk2.Resource):
    """
    Busybox static binary, see: https://busybox.net
    """
    releasable = True
    auto_backup = True


class ARCHIVE_TAR(sdk2.Resource):
    """
    Generic tag gz archive
    """
    releasable = True
    auto_backup = True


class ARCHIVE_TAR_GZ(sdk2.Resource):
    """
    Generic tag gz archive
    """
    releasable = True
    auto_backup = True


class ARCHIVE_TAR_BZ(sdk2.Resource):
    """
    Generic tag bz2 archive
    """
    releasable = True
    auto_backup = True


class ARCHIVE_TAR_ZSTD(sdk2.Resource):
    """
    Generic tag zstd archive
    """
    releasable = True
    auto_backup = True


class GIT_ARCHIVE_TAR(sdk2.Resource):
    """
    Git archive tar
    """
    releasable = True
    auto_backup = True
    git_ref = sdk2.parameters.String("Git reference")
    git_sha = sdk2.parameters.String("Git SHA")
    git_remote = sdk2.parameters.String("Git remote")
    ctx = sdk2.parameters.String("Caller context")


class GIT_ARCHIVE_TAR_ZST(GIT_ARCHIVE_TAR):
    """
    Git archive tar.zst
    """
    releasable = True


class DebPackage(sdk2.Resource):
    """
    Debian package
    """
    releasable = True
    auto_backup = True
    deb_package = sdk2.Attributes.String("Debian package name", required=True)
    deb_version = sdk2.Attributes.String("Debian package version", required=True)
    deb_md5 = sdk2.Attributes.String("md5 checksum", required=False)
    deb_sha1 = sdk2.Attributes.String("sha1 checksum", required=False)
    deb_sha256 = sdk2.Attributes.String("sha256 checksum", required=False)


class DebPackageChanges(DebPackage):
    "Debian package .changes file"


class DebPackageSource(DebPackage):
    "Debian source package"


class DebPackageSourceDsc(DebPackage):
    "Debian source package .dsc file"


class PBUILDER_CONFIG(sdk2.Resource):
    "Pbuilder config"
    releasable = True
    auto_backup = True
    distribution = sdk2.Attributes.String("distribution", required=True)
    platform = sdk2.Attributes.String("platform", required=True)
    config_origin = sdk2.Attributes.String("config_origin", required=True)


class GENERIC_PBUILDER_TARBALL(sdk2.Resource):
    "Pbuilder base tarball"
    releasable = True
    auto_backup = True
    distribution = sdk2.Attributes.String("distribution", required=True)
    platform = sdk2.Attributes.String("platform", required=True)
    config_resource = sdk2.Attributes.String("config resoure", required=True)
    config_origin = sdk2.Attributes.String("config_origin", required=True)


class KERNEL_PBUILDER_TARBALL(GENERIC_PBUILDER_TARBALL):
    "Pbuilder base tarball for linux kernel package build"
    releasable = True
    auto_backup = True


class PORTO_PBUILDER_TARBALL(GENERIC_PBUILDER_TARBALL):
    "Pbuilder base tarball for yandex-porto package build"
    releasable = True
    auto_backup = True
