# coding: utf-8

import logging
import requests
import re


def to_juggler_service_name(name):
    # replace symbols to "_" to satisfy https://a.yandex-team.ru/arc/trunk/arcadia/juggler/libjuggler/validators/system.py?blame=true&rev=3519248#L9
    return re.sub(r'[^\w\-+=\./\t ]', '_', name)


def send_events_to_juggler(host, service, status, description):
    send_multi_events_to_jugger([(host, service, status, description)])


def send_multi_events_to_jugger(events):
    """
    Sends multiple events to juggler at once
    :param events: list of four-tuple - host, service, status, description
    :return:
    """
    try:
        reply = requests.post("http://juggler-push.search.yandex.net/events", json={
            "source": "sandbox",
            "events": [{
                "host": host,
                "service": service,
                "status": status,
                "description": description
            } for host, service, status, description in events]
        })
        event_statuses = reply.json()["events"]
        errors = [event_status["error"] for event_status in event_statuses if event_status["code"] != 200]
        if errors:
            raise Exception("\n".join(errors))
    except Exception:
        logging.exception("unable to get frontend nodes from juggler")
