# -*- coding: utf-8 -*-
import logging

import boto3


class S3Client(object):
    service_name = 's3'

    def __init__(self, s3_endpoint, access_key, key_id, bucket_name):
        session = boto3.session.Session()
        self.bucket_name = bucket_name
        self.s3_endpoint = s3_endpoint
        self.s3 = session.client(
            service_name=self.service_name,
            endpoint_url='https://{}'.format(self.s3_endpoint),
            aws_access_key_id=key_id,
            aws_secret_access_key=access_key
        )

    def delete(self, upload_key):
        logging.info('Removing {0} from Object Storage'.format(upload_key))
        try:
            self.s3.delete_object(Bucket=self.bucket_name,
                                  Key=upload_key)
            return True
        except Exception as e:
            logging.error('Cant delete object %s with error %d', (upload_key, e))
            return False

    def exists(self, mds_key):
        try:
            self.s3.head_object(Bucket=self.bucket_name,
                                      Key=mds_key)
            return True
        except Exception:
            return False

    def upload(self, local_path, mds_path):
        logging.info('Trying to upload {0} with path {1}'.format(mds_path, local_path))
        try:
            self.s3.upload_file(local_path, self.bucket_name, mds_path)
        except IOError:
            logging.error('Cant find file {0}'.format(local_path))

        if self.exists(mds_path):
            return {
                'mds_http': 'http://{0}/{1}/{2}'.format(self.s3_endpoint, self.bucket_name, mds_path),
                'mds_https': 'https://{0}/{1}/{2}'.format(self.s3_endpoint, self.bucket_name, mds_path),
                'mds_key': mds_path
            }
        else:
            raise Exception('Unable to upload to object storage')
