import requests
from sandbox.sandboxsdk.task import SandboxTask


class JugglerNotifyingSandboxTask(SandboxTask):
    """Sends juggler raw events on task completion"""

    juggler_source = 'sandbox_task_status_monitoring'

    def on_finish(self):
        SandboxTask.on_finish(self)
        self.notify_juggler_about_status(success=True)

    def on_success(self):
        SandboxTask.on_success(self)
        self.notify_juggler_about_status(success=True)

    def on_failure(self):
        SandboxTask.on_failure(self)
        self.notify_juggler_about_status(success=False)

    def on_break(self):
        SandboxTask.on_break(self)
        self.notify_juggler_about_status(success=False)

    def on_timeout(self):
        SandboxTask.on_timeout(self)
        self.notify_juggler_about_status(success=False)

    def notify_juggler_about_status(self, success):
        self.send_raw_juggler_event(source=self.juggler_source,
                                    description=self.get_juggler_description(),
                                    host=self.get_juggler_host(),
                                    service=self.get_juggler_service(),
                                    status=success)

    @staticmethod
    def send_raw_juggler_event(source, description, host, service, status, instance=''):
        req = {
            'source': source,
            'events': [
                {
                    'description': description,
                    'host': host,
                    'instance': instance,
                    'service': service,
                    'status': 'OK' if status else 'CRIT'
                }]
        }
        reply = requests.post('http://juggler-push.search.yandex.net/events',
                              json=req,
                              timeout=10)
        event_status = reply.json()['events'][0]
        if event_status['code'] != 200:
            raise Exception(event_status['error'])

    def get_juggler_description(self):
        raise NotImplementedError

    def get_juggler_host(self):
        raise NotImplementedError

    def get_juggler_service(self):
        raise NotImplementedError
