# Kosher Releases a.k.a. Kvasov-Korum Scheme

Альтернатива дефолтной схеме релизов в Sandbox, решающая проблемы независимости релизов и откатов

Историю появления и размышления про релизы можно почитать тут:

- https://dkvasov.at.yandex-team.ru/11
- https://st.yandex-team.ru/SANDBOX-4691
- https://st.yandex-team.ru/RMDEV-2380

## Что не так с Sandbox релизами

> **Пример: пропадающий тестинг**
>
> Пусть некоторый ресурс `R` зарелизили в testing.  А затем его же зарелизили в stable. В дефолтных Sandbox'овых релизах
> `R` пересает быть зарелиженным в testing и в этом месте всякая механика, полагающаяся на testing-релизы, либо просто
> ломается (если не может найти ресурс), либо начинает работать неправильно, так как находит теперь более ранний ресурс
> (который был когда-то зарелижен в testing, но не был потом зарелижен куда-то еще).

Реализация релизов в Sandbox не позволяет корректно разрешать подобные ситуации и в ряде случаев это становится
критической проблемой, которая мешает людям нормально работать или выливается в неожиданное/недопустимое поведение.
Еще один класс проблем — откаты в рамках стейджа и/или отмена релиза — также не решаются нормально в нативной схеме.

## Что умеет

- **Независимые релизы**.
  Любой ресурс в любой момент времени можно зарелизить в любой стейдж и это приведет к единственно
  верному результату — ресурс окажется зарелиженным в этот стейдж и **больше ничего** (в частности, не перестанет быть
  зарелиженным в другие стейджы, если таковые имелись).
- **Произвольные стейджи**.
  Не обязательно ограничиваться stable|testing|prestable|unstable, имя стейджа можно выбирать
  любое, если это зачем-то нужно ("Войну и мир" вот имя впихивать, конечно, не стоит — нужно соблюдать разумные пределы).
- **Откат накатом**.
  Нужно откатиться на какую-то версию? Берем и кошер-релизим соответствующий ресурс в соответствующий стейдж. При этом
  другие стейджи останутся без изменений (т.е., например, если `R2` — последний зарелиженный в testing и в stable ресурс
  и мы откатываем stable на `R1`, то `R2` останется последним зарелиженным в testing)
- **Отмена релиза**.
  Релиз ресурса можно "отменить" — пометить его "плохим" — для заданного стейджа. Технически это реализуется через
  Sandbox-релиз в cancelled и удаление релизного атрибута.

## Как это работает

Кошер-релизы построены на атрибутах ресурсов. При релизе ресурса `R` в некоторый стейдж `s` ресурс получает специальный
атрибут, имя которого указывает на стейдж, а значение хранит время релиза. Поиск релиза в таком случае сводится к
получению ресурсов заданного типа и с нашим специальным релизным атрибутом (опциально возможна фильтрация по
дополнительным атрибутам) с последующей сортировкой по значению релизного атрибута (вычислению последнего).

Схема kosher release совместима с Sandbox-релизами в следующем смысле: ресурс, зарелиженный посредством kosher release
в стейдж, поддерживаемый нативными Sandbox-релизами, оказывается также зарелижен в нативном для Sandbox смысле. Иными
словами, переход на kosher release безопасен для тех, кто завязан на нативную схему — все соответствующие процессы
продолжат работать. В этом случае при "кошерном" релизе инициируется также и нативный релиз (букально, прожимается
кнопка Release у задачи, породившей заданный ресурс).

Обратное неверно: зарелиженное по нативной SB-схеме не будет распознано средствами kosher release.


## Как использовать

### Основные функции

- `kosher_release.find_release` — найти релиз заданного ресурса в заданный стейдж (возвращает ID ресурса)
- `kosher_release.release` — зарелизить заданный ресурс в заданный стейдж
- `kosher_release.cancel` — отменить релиз ресурса в заданный стейдж

### Kosher Release Tool

https://a.yandex-team.ru/arc_vcs/sandbox/projects/common/kosher_release/tool

Программка для поиграться, потестить или даже оперативно что-то катнуть

```
$ cd arc/arcadia/sandbox/projects/common/kosher_release/tool
$ ya m
$ ./k_release_tool --help
```

Примеры:

- `./k_release_tool find-release METRICS_TEMPLATE_RESOURCE stable`
  — найти текущий stable ресурс METRICS_TEMPLATE_RESOURCE
- `./k_release_tool find-release SANDBOX_TASKS_BINARY stable task_type=LAUNCH_METRICS`
  — найти текущий stable ресурс задачи LaunchMetrics
- `./k_release_tool release 3037341995 prestable`
  — зарелизить ресурс с ID 3037341995 в prestable
