#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from sandbox.projects.common import utils
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.environments import VirtualEnvironment, PipEnvironment
from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.process import run_process


class ConfigGenerator(object):
    def __init__(self, config_generator_path, env_type, report_logs_folder=None):
        self.config_generator_path = config_generator_path
        self.env_type = env_type
        self.config_template_path = os.path.join(self.config_generator_path, 'etc/template.cfg')
        if report_logs_folder is not None:
            self.log_folder = report_logs_folder
        else:
            self.log_folder = make_folder('report_logs')
        self.template_id = None

    def generate(self, index_path, port):
        config_folder = utils.create_misc_resource_and_dir(
            ctx=channel.task.ctx,
            ctx_field_name="market_report_configs",
            descr="Configs generation stuff",
            dir_name="market_report_configs",
        )

        config_tmpl_file = os.path.join(config_folder, "config_template.cfg")
        self_dir = os.path.dirname(os.path.abspath(__file__))
        subst_path = '\/var\/lib\/search'

        to_subst_path = index_path.replace('/', '\/')
        with open(config_tmpl_file, 'w') as config_template:
            run_process(['sed  -e',
                         '"s/%s/%s/g"' % (subst_path, to_subst_path),
                         self.config_template_path],
                        stdout=config_template,
                        shell=True, check=True)

        for dir_tp in [('\/var\/log\/search', self.log_folder),
                       ('\/var\/run\/search', config_folder)]:
            to_subst_path = dir_tp[1].replace('/', '\/')
            run_process(['sed -i -e',
                         '"s/%s/%s/g"' % (dir_tp[0], to_subst_path),
                         config_tmpl_file],
                        shell=True, check=True)

        run_process(['sed -i -e',
                     '"s/17051/%s/g"' % port,
                     config_tmpl_file],
                    shell=True, check=True)

        dest_keys = os.path.join(config_folder, 'clickdaemon.keys')
        self._write_clickdaemon_keys(dest_keys)

        run_process(['sed -i -e',
                     '"/<\/MarketReport>/i  UrlEncKeysFile %s"' % dest_keys.replace('/', '\/'),
                     config_tmpl_file],
                    shell=True, check=True)

        report_config = os.path.join(config_folder, 'report_config.cfg')

        with VirtualEnvironment() as venv:
            PipEnvironment('mako',
                           None, use_wheel=True,
                           venv=venv).prepare()
            PipEnvironment('pycurl',
                           None, use_wheel=True,
                           venv=venv).prepare()
            run_process(
                [
                    venv.executable,
                    os.path.join(self.config_generator_path, 'market_search_cfg_generator.py'),
                    config_tmpl_file,
                    report_config,
                    '--set-prop "DISABLE_RANDOM=1"',
                    '--set-prop "REPORT_TYPE=market-report"',
                    '--set-prop "LOCAL_PARTS[]=0"',
                    '--set-prop "MODEL_LOCAL_PARTS[]=0"',
                    '--set-prop "ENV_TYPE={}"'.format(self.env_type),
                    '--log-file {}'.format(os.path.join(config_folder, 'config-generator.log')),
                ],
                work_dir=self_dir,
                shell=True,
                check=True)
        return report_config

    def _write_clickdaemon_keys(self, filepath):
        with open(filepath, 'w') as f:
            f.write(
                'aR3zxenEu6+rgV84g2qoHQ==\n'
                'ayFVMGPqmKf4pZ0rnsGMGQ==\n'
                '24ntBqnEvWw3jHAvnKJEvA==\n'
                'hqYz6+YZIl4AfHzMUGl/xA==\n'
                'YesPFJdHJwAECaqFelNVTw==\n'
                'W50/PxLsdRldOKXKklW4Ng==\n'
                'WHiJLfjkTpzeaMP65r1Gnw==\n'
                'eEyd0ZW5Mpma9X9/8/MvIw==\n'
                'RruX5oob0hJiwwjiZsX9xg==\n'
                'FrWYBOOTWYsr+mTFZd1lHA==\n'
                'yyf/T+rhLFnEOmw1Xxnjhg==\n'
                'JsONbaMTM6whc5BrvVakUg==\n'
                'iVR/KzErTBb4F0rQXBh48g==\n'
                'ap94v+rJUKjDCIZRiF2cGg=='
            )
