# coding: utf-8
"""
Turn class inherited from control.Basecontrol into command line program
"""
import argparse
import wrapper
import json
import sys


def command(control):
    arg_parser = argparse.ArgumentParser(description=u"Run {} from command line".format(control.__name__))
    arg_parser.add_argument('input_plan', help="file to iterate")
    arg_parser.add_argument('-n', type=int, help="queries limit", default=10)
    arg_parser.add_argument('-l', '--log', metavar='FILE', nargs='?', default=None, help=u'log here')
    arg_parser.add_argument('-m', '--max-rps', type=int, help="RPS limit", default=100)
    arg_parser.add_argument('-o', '--output', metavar='FILE', nargs='?', default=None, help=u'output file')
    arg_parser.add_argument('-p', '--progress', action="store_true", help="display progress")
    arg_parser.add_argument('-d', '--debug', action="store_true", help="log every query")
    arg_parser.add_argument('-e', '--extra', metavar='FILE', nargs='?', default=None, help="extra resource")
    arg_parser.add_argument('-c', '--context', metavar='CONTEXT', nargs='?', default=None, help="context data")

    args = arg_parser.parse_args()

    with open(args.log or "/dev/stderr", "w") as log:
        with open(args.output, "w") if args.output else wrapper.none_stream() as output:
            results = None
            it = wrapper.query_iterator(control, args.input_plan, args.n)
            log_to = "debug_log_stream" if args.debug else "info_log_stream"
            log_args = {log_to: log}
            context = json.loads(args.context) if args.context else None
            mp = wrapper.multiprocess(
                it, control, args.max_rps, control.default_query_url_template,
                output_stream=output, extra_resource=args.extra, context=context, **log_args
            )

            for r in mp:
                results = r
                if args.progress:
                    sys.stdout.write(".")
                    sys.stdout.flush()

            print
            data = control.template_data(results)
            namelen = max([len(x["name"]) for x in data])
            for item in data:
                name = (item["name"] + ":").ljust(namelen+2)
                fraction = " {:.2f}%".format(item["fraction"]*100) if item["fraction"] is not None else ""
                value = item["value"] if isinstance(item["value"], str) else "{:.2f}".format(item["value"])
                value = value.ljust(10)
                print name + value + fraction
