# -*- coding: utf-8 -*-

import string
import urlparse

REQUEST_TEMPLATES = (
    "{text}",
    "{text} url:{urls[0]}",
    "{text} url:{urls[0]!W}",
    "{text} url:{urls[0]} | url:{urls[1]}",
    "{text} url:{urls[0]!W} | url:{urls[1]!W}",
    "{text} host:{urls[0]!H}",
    "url:{urls[0]}",
    "host:{urls[0]!H}",
    "url:{urls[0]} | url:{urls[1]}",
    "название песни ту ту ту ру ту ту ру ру",  # SEARCHPRODINCIDENTS-1379
    "слова песни и только лишь со мной она так уникальна",  # SEARCHPRODINCIDENTS-1379
    "video search dfskdlfjsdfsdf",  # IMAGES-10800
    "http asdfasdfsadfadslhkjfddj com",  # IMAGES-10800
    "abçlüö.com",  # IMAGES-10800
)


class Formatter(string.Formatter):
    def convert_field(self, value, conversion):
        if conversion == "H":
            return urlparse.urlparse(value).netloc
        elif conversion == "W" and len(value) > 2:
            return value[:-2] + "*"
        else:
            return super(Formatter, self).convert_field(value, conversion)


_FORMATTER = Formatter()


def generate_requests(text, urls):

    def _ensure_utf8(x):
        if isinstance(x, unicode):
            return x.encode("utf-8")
        else:
            return x

    urls = [_ensure_utf8(u) for u in urls]
    for fmt in REQUEST_TEMPLATES:
        yield (fmt, _FORMATTER.format(fmt, text=text, urls=urls))
