import logging
import time

from sandbox import common

from sandbox.projects.common.yasm import push_api


_MONITORING_ATTEMPTS_KEY = "monitoring_attempts"


class YasmTask:
    push_signal_name = None
    push_signal_ttl = 5 * 86400  # 5 days

    # Note: Use restart_on_failure only if you are explicitly mark target resources as ready
    def _yasm_notify(self, push_signal_name=None, task_status="success", restart_on_failure=False, value=None, signal_ttl=None):
        """
            Send signal to local yasm agent

            task_status        - signal name variant, default value is success
            restart_on_failure - raise TemporaryError on failure to give task a second chance to work
                                 This option is incompatible with schedulers with 'sequential run'
        """
        push_signal_name = push_signal_name or self.push_signal_name
        signal_ttl = signal_ttl or self.push_signal_ttl

        if push_signal_name is None:
            logging.info("Signal name or ttl is not defined, nothing to send to monitoring system")
            return

        if value is None:
            value = int(time.time())

        try:
            signal_name = "{}_{}_xxxx".format(push_signal_name, task_status)
            push_api.push_signal(signal_name, "imgs", value, itype="asandbox", ttl=signal_ttl)
            logging.info("Set value of signal {} to {} with ttl {} successfully".format(signal_name, value, signal_ttl))
        except push_api.PushError as e:
            logging.error("Failed to push signal to yasm: {}".format(e))
            if restart_on_failure and e.status == "urlerror":  # Problems with local agent, try on other host again
                self.ctx[_MONITORING_ATTEMPTS_KEY] = self.ctx.get(_MONITORING_ATTEMPTS_KEY, 0) + 1
                logging.info("Try again (number of attempts={})".format(self.ctx[_MONITORING_ATTEMPTS_KEY]))
                raise common.errors.TemporaryError(str(e))
        except Exception as e:
            logging.error("Exception during pushing signal to yasm: {}".format(e))
