# -*- coding: utf-8 -*-

from sandbox.projects.common.base_search_quality.tree import node as tn
from sandbox.projects.common.search import response_patcher as rpatch


_direct_query_classif = (
    "DirectQueryClassif.alc",
    "DirectQueryClassif.gam",
    "DirectQueryClassif.med",
    "DirectQueryClassif.trg",
)


def response_patcher(response):
    """
        Преобразуем scheme из json строки в поддерево данных ответа (если ещё не сделано),
        удаляем специфичные для ответов среднего поля с нестабильными данными
        (разнятся при ответах из кеша и пр...)
        Convert scheme json to tree if need,
        remove unstable middlesearch-specific data
    """
    rpatch.convert_scheme_to_tree(response)

    # remove parameters flapped in responses from middlesearch cache
    # remove {scheme-tree}/Local/DeletedUrlsByDupCateg/
    tn.WalkPath(
        response,
        (rpatch.KEY_SCHEME_TREE, "Local"),
        lambda node: rpatch.purge(node, "DeletedUrlsByDupCateg"),
    )
    # remove {scheme-tree}/Local/Filters/trie
    tn.WalkPath(
        response,
        (rpatch.KEY_SCHEME_TREE, "Local", "Filters"),
        lambda node: rpatch.purge(node, "trie"),
    )
    # remove {scheme-tree}/Local/DeletedUrlsByDupCateg/
    tn.WalkPath(
        response,
        (rpatch.KEY_SCHEME_TREE, "Local"),
        lambda node: rpatch.purge(node, "ReqDocsUrls"),
    )
    # remove {scheme-tree}/DirectQueryClassif/
    tn.WalkPath(
        response,
        (rpatch.KEY_SCHEME_TREE, ),
        lambda node: rpatch.purge(node, "DirectQueryClassif"),
    )
    searchProp = response._nodes.get("SearcherProp")
    if searchProp:
        fixed_sp = []
        for sp in searchProp:
            # remove /SearcherProp/Filters.1*
            # remove /SearcherProp/DirectQueryClassif.alc
            # remove /SearcherProp/DirectQueryClassif.gam
            # remove /SearcherProp/DirectQueryClassif.med
            # remove /SearcherProp/DirectQueryClassif.trg
            key = sp.GetPropValue("Key")
            prefix = ("Filters.1/", "Cached_")
            if not key.startswith(prefix) and key not in _direct_query_classif:
                fixed_sp.append(sp)
        response._nodes["SearcherProp"] = fixed_sp
