# -*- coding: utf-8 -*-

from sandbox.projects.common.search import components
from . import single_host
from sandbox.projects.common.search import settings as media_settings


_BASESEARCH1_PARAMS = components.create_noweb_basesearch_params(n=1)
_BASESEARCH2_PARAMS = components.create_noweb_basesearch_params(n=2)


class VideoMiddlesearchSingleHostTask(single_host.MiddlesearchSingleHostTask):

    input_parameters = _BASESEARCH1_PARAMS.params + _BASESEARCH2_PARAMS.params + components.DefaultMiddlesearchParams.params

    def on_execute(self):
        media_settings.VideoSettings.ensure_search_database(
            self.ctx,
            self._get_queries_parameter(),
            _BASESEARCH1_PARAMS.Database,
            _BASESEARCH2_PARAMS.Database,
        )
        single_host.MiddlesearchSingleHostTask.on_execute(self)

    def _get_queries_parameter(self):
        raise NotImplementedError()
