# coding: utf-8

import requests

from .models import Issue, Transition, Comment, IssueLink, Attachment, \
    ChangelogEntry, Queue, IssueType, Priority, Status, Resolution, Component, Version, Project


class Startrek(object):

    def __init__(self, token, useragent, path="https://st-api.yandex-team.ru", timeout=1.0):
        self.session = requests.Session()
        self.session.headers['Authorization'] = 'OAuth ' + token
        self.session.headers['Content-Type'] = 'application/json'
        useragent += ' via st-python-client/0.4.11'
        self.session.headers['User-Agent'] = useragent
        self.path = path
        self.token = token
        self.timeout = timeout

    def get_issue(self, id):
        issue = Issue(self)
        issue.get(id)
        return issue

    def create_issue(self, data):
        issue = Issue(self)
        issue.create(data)
        return issue

    def update_issue(self, id, **kwargs):
        issue = Issue(self)
        issue.update_one(id, **kwargs)

    def find_issues(self, query, limit=50):
        return Issue(self).get_all(query, limit)

    def get_transition(self, issue, id):
        transition = Transition(self)
        transition.get(issue, id)
        return transition

    def get_transitions(self, id):
        return Transition(self).get_all(id)

    def get_comment(self, issue, id):
        comment = Comment(self)
        comment.get(issue, id)
        return comment

    def add_comment(self, issue, text, *args):
        comment = Comment(self)
        comment.create(issue, text, *args)
        return comment

    def update_comment(self, issue, id, text, *args):
        comment = Comment(self)
        comment.update_one(issue, id, text, *args)
        return comment

    def get_comments(self, id):
        return Comment(self).get_all(id)

    def delete_comment(self, issue, id):
        comment = Comment(self)
        comment.delete_one(issue, id)

    def get_link(self, issue, id):
        link = IssueLink(self)
        link.get(issue, id)
        return link

    def get_links(self, id):
        return IssueLink(self).get_all(id)

    def add_link(self, issue, relationship, to):
        link = IssueLink(self)
        link.create(issue, relationship, to)
        return link

    def delete_link(self, issue, id):
        link = IssueLink(self)
        link.delete_one(issue, id)

    def link(self, issue, resource, relationship):
        link = IssueLink(self)
        link.link(issue, resource, relationship)
        return link

    def unlink(self, issue, resource, relationship):
        link = IssueLink(self)
        link.unlink(issue, resource, relationship)

    def get_attachment(self, issue, id):
        attachment = Attachment(self)
        attachment.get(issue, id)
        return attachment

    def get_attachments(self, id):
        return Attachment(self).get_all(id)

    def get_changelog(self, issue, sort='asc', fields=(), types=()):
        return ChangelogEntry(self).get_all(issue, sort, fields, types)

    def get_changelog_entry(self, issue, id):
        return ChangelogEntry(self).get(issue, id)

    def upload_attachment(self, issue, file):
        attachment = Attachment(self)
        attachment.upload(issue, file)

    def delete_attachment(self, issue, id):
        attachment = Attachment(self)
        attachment.delete_one(issue, id)

    def get_queue(self, id):
        queue = Queue(self)
        queue.get(id)
        return queue

    def get_queues(self):
        return Queue(self).get_all()

    def get_issue_types(self):
        return IssueType(self).get_all()

    def get_priorities(self):
        return Priority(self).get_all()

    def get_statuses(self):
        return Status(self).get_all()

    def get_resolutions(self):
        return Resolution(self).get_all()

    def get_components(self):
        return Component(self).get_all()

    def get_queue_components(self, queue):
        return Component(self).get_by_queue(queue)

    def get_versions(self):
        return Version(self).get_all()

    def get_queue_versions(self, queue):
        return Version(self).get_by_queue(queue)

    def add_version(self, queue, version_name, **kwargs):
        version = Version(self)
        version.create_for_queue(queue, version_name, **kwargs)
        return version

    def get_projects(self):
        return Project(self).get_all()

    def get_queue_projects(self, queue):
        return Project(self).get_by_queue(queue)

    def get_queue_issue_types(self, queue):
        return IssueType(self).get_by_queue(queue)
