# -*- coding: utf-8 -*-
import logging
import os

import sandbox.common.types.client as ctc
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.projects.common.environments import SandboxJavaJdkEnvironment
from sandbox.projects.common.environments import SandboxAntEnvironment
from sandbox.sandboxsdk.environments import SvnEnvironment
from sandbox.sandboxsdk.errors import SandboxTaskFailureError
from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.paths import copy_path
from sandbox.sandboxsdk.process import run_process

from ..mobvcs import VcsTypeParam, VcsUrlParam, VCS_REGISTRY


class AntDirParam(SandboxStringParameter):
    name = 'ant_dir'
    description = 'ANT dir (relative)'
    default_value = 'deploy/yandex-mobilesearch-gateway-1.0'


class BaseAntBuildTask(SandboxTask):
    environment = (
        SvnEnvironment(),
        SandboxJavaJdkEnvironment('1.7.0'),
        SandboxAntEnvironment('1.8.4'),
    )

    input_parameters = (VcsTypeParam, VcsUrlParam, AntDirParam)
    resources = []
    archs_for_bundle = ('linux',)
    vcs_dir = 'checkout'
    dist_dir = 'dist'
    client_tags = ctc.Tag.Group.LINUX

    def on_execute(self):
        self.get_src()
        self.run_ant()
        self.make_resource()
        self.set_info('Task completed successfully.')

    def get_src(self):
        logging.info('Obtaining source tree using %s' % self.ctx['vcs_type'])
        vcs = VCS_REGISTRY[self.ctx['vcs_type']](self.ctx['vcs_url'], self.path(self.vcs_dir))
        vcs.obtain()

    def run_ant(self):
        run_dir = os.path.join(self.path(self.vcs_dir), self.get_ant_dir(), '')
        logging.info('Running ant in %s with args %s' % (run_dir, self.ant_args()))
        run_process(['ant ' + self.ant_args()], 'ant', shell=True, timeout=10800, check=True, work_dir=run_dir)

    def make_resource(self):
        run_dir = os.path.join(self.path(self.vcs_dir), self.get_ant_dir(), '')
        dist_dir = os.path.join(self.abs_path(), self.dist_dir, '')
        try:
            make_folder(dist_dir)
            for res in self.resources:
                resource_path = os.path.join(run_dir, res[2], res[0])
                copy_path(resource_path, os.path.join(dist_dir, res[0]))
                self.create_resource(self.descr, os.path.join(dist_dir, res[0]), res[1])
        except IOError, e:
            raise SandboxTaskFailureError('Unable to copy file. %s' % e)

    def ant_args(self):
        raise NotImplementedError('Method ant_args is not implemented')

    def get_ant_dir(self):
        return self.ctx.get('ant_dir', '')

    def arcadia_info(self):
        """
            Получение информации о задаче при релизе
            Может быть переопределён в наследниках для уточнения возвращаемых данных
            @return список из трёх значений revision, tag, branch
        """
        return 'test', 'test', 'trunk'


__Task__ = BaseAntBuildTask
