# -*- coding: utf-8 -*-


class Version(object):
    def __init__(self, major_version, minor_version):
        self.major = major_version
        self.minor = minor_version

    def previous_minor(self):
        if self.minor > 0:
            return Version(self.major, self.minor - 1)
        raise ValueError("No previous minor version")

    def next_minor(self):
        return Version(self.major, self.minor + 1)

    def next_major(self):
        return Version(self.major + 1, 0)

    def is_major(self):
        return self.minor == 0

    def __str__(self):
        return '%d.%d' % (self.major, self.minor)
