# coding: utf-8

from sandbox.projects.common.nanny import nanny


class AutoNannyDeployTask(nanny.ReleaseToNannyTask):
    """
        Класс для автоматического делоя через няню.

        Для того, чтобы ваш таск мог изменять конфигурацию сервиса и выкладывать его, нужно выдать роботу nanny-robot
        соответствующие права на ваш сервис (вкладка Administrators):
            * Operation manager - если вам нужен автоматический деплой.
            * Configuration manager - если нужно автоматическое обновление конфигурации сервиса.

        В наследнике можно переопределить:
        get_stable_services - список сервисов, которые будут обновляться при релизе
        get_testing_services - список сервисов, которые будут обновляться
                           при сборке таска с флажком Send to searchpriemka
                           или при релизе в testing
        auto_deploy - если False, то сервис обновляется, но не перевыкатывается
        update_comment - комментарий к обновлению конфигурации сервиса. Умеет параметры, подробности - в docstring к
                         update_service_sandbox_resources.
        deploy_comment - комментарий к заданию автоматической выкладки. Умеет те же параметры, что и update_comment.
    """
    auto_deploy = True
    update_comment = None
    deploy_comment = None
    raise_if_not_changed = False

    def get_stable_services(self):
        return []

    def get_testing_services(self):
        return []

    def get_url_resources(self):
        return []

    def get_nanny_oauth_token(self):
        return None

    def _update_service(self, service_id):
        oauth_token = self.get_nanny_oauth_token()
        nanny_client = nanny.NannyClient(api_url='http://nanny.yandex-team.ru/',
                                         oauth_token=oauth_token)
        nanny_client.update_service_sandbox_resources(
            service_id=service_id,
            task_type=self.type,
            task_id=str(self.id),
            comment=self.update_comment,
            deploy=self.auto_deploy,
            deploy_comment=self.deploy_comment,
            raise_if_not_changed=self.raise_if_not_changed,
        )
        for resource_type in self.get_url_resources():
            nanny_client.update_service_sandbox_url_file(
                service_id=service_id,
                resource_type=resource_type,
                task_id=str(self.id),
                comment=self.update_comment,
                deploy=self.auto_deploy,
                deploy_comment=self.deploy_comment,
            )

    def update_stable_services(self):
        for service_id in self.get_stable_services():
            self._update_service(service_id)

    def update_testing_services(self):
        for service_id in self.get_testing_services():
            self._update_service(service_id)

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        if additional_parameters['release_status'] == 'stable':
            self.update_stable_services()
        elif additional_parameters['release_status'] == 'testing':
            self.update_testing_services()
