# -*- coding: utf-8 -*-

# Основной url сервиса
NANNY_API_URL = 'http://nanny.yandex-team.ru/'

# Url сервиса для разработки и тестирования
NANNY_DEV_API_URL = 'http://dev-nanny.yandex-team.ru/'

# Url админского контура Няни
NANNY_ADM_API_URL = 'http://adm-nanny.yandex-team.ru/'

# Шаблон для получения ссылки на release request
RELEASE_REQUEST_TEMPLATE = '{nanny_api_url}ui/#/r/{release_request_id}/'

# Ключ контекста для отправления нотификаций в релизный тикет
# https://wiki.yandex-team.ru/JandeksPoisk/Sepe/nanny/sandbox-integration/#startrek-tickets-integration
STARTREK_TICKET_IDS_KEY = 'startrek_ticket_ids'

# Subject релиза (проявляется в т.ч. в заголовке тикета Nanny)
RELEASE_SUBJECT_KEY = 'release_subject'

# Набор webhook-ов, которые будут вызваны при закрытии релиза
WEBHOOK_URLS_KEY = 'webhook_urls'

# Формат содержимого вебхука:
#   - RELEASE_ONLY - только содержание релиза
#   - RELEASE_WITH_TICKETS - содержание релиза и связанных с ним тикетов
WEBHOOK_TYPE_KEY = 'webhook_type'

# Компонент релиза. Используется для поиска дубликатов.
COMPONENT_KEY = 'component'

# Политика обработки дубликатов релиза.
DUPLICATE_POLICY_TYPE_KEY = 'duplicate_policy_type'

# Словарь string-string c лейблами релиза
LABELS = 'release_labels'

# Описание релиза
RELEASE_COMMENTS = 'release_comments'
