# coding: utf-8
import urllib2
import json
from sandbox import sdk2
import sandbox.common.errors as ce
import time

# tags, mute all news alerts with tag=auto_downtime
JUGGLER_CHECKS = [
    ["auto_downtime", "a_ctype_prestable", "a_itype_apphost", "a_prj_news"],
    ["auto_downtime", "a_ctype_prod", "a_itype_apphost", "a_prj_news"]
]


def GetLoadTestingFlags():
    request = urllib2.Request('http://its.yandex-team.ru/v1/values/newsupper/sas/News/load_testing_flags/', headers={
        'Accept': 'application/json',
        'Content-Type': 'application/json; charset=utf-8',
        'Authorization': 'OAuth ' + sdk2.Vault.data('NEWS', 'robot_ynews_nanny_oauth_token')
    })

    data = json.loads(urllib2.urlopen(request).read())

    assert data["path"] == "newsupper/sas/News/load_testing_flags"
    assert "user_value" in data

    print("Got following load testing flags from its: " + data["user_value"])

    load_testing_flags = json.loads(data["user_value"])

    return load_testing_flags


def CheckL7ItsWeights(name, section):
    request = urllib2.Request('http://its.yandex-team.ru/v2/l7/heavy/{}/weights/values/'.format(name), headers={
        'Authorization': 'OAuth ' + sdk2.Vault.data('NEWS', 'robot_ynews_nanny_oauth_token')
    })

    data = json.loads(urllib2.urlopen(request).read())
    print("{}/{}: Got following L7 weights from ITS: {}\n".format(name, section, data))

    assert 'weight' in data["sections"][section]["locations"]["SAS"]

    value = int(data["sections"][section]["locations"]["SAS"]["weight"])

    print("{}/{}: SAS weight is considered to be {}".format(name, section, value))

    if value != 0:
        raise ce.TaskError("{}/{}: Can't disable neighbours if location is not closed. Current weight: {} != 0".format(name, section, value))


def GetItsData():
    request = urllib2.Request('http://its.yandex-team.ru/v1/values/newsupper/sas/News/', headers={
        'Accept': 'application/json',
        'Content-Type': 'application/json; charset=utf-8',
        'Authorization': 'OAuth ' + sdk2.Vault.data('NEWS', 'robot_ynews_nanny_oauth_token')
    })

    data = json.loads(urllib2.urlopen(request).read())

    assert 'newsupper/sas/News/common_news_flags' in data

    value = data['newsupper/sas/News/common_news_flags']['value']
    version = '"' + data['newsupper/sas/News/common_news_flags']['version'] + '"'

    print("Got following data from its: " + version + "\n" + value)

    return value, version


def SetItsData(value, version):
    result = {}
    result["value"] = value
    post = urllib2.Request('http://its.yandex-team.ru/v1/values/newsupper/sas/News/common_news_flags/', json.dumps(result), headers={
        'Accept': 'application/json',
        'Content-Type': 'application/json; charset=utf-8',
        'Authorization': 'OAuth ' + sdk2.Vault.data('NEWS', 'robot_ynews_nanny_oauth_token'),
        'If-Match': version
    })

    print(urllib2.urlopen(post).read())


def GetGeneralJugglerRequest(checks):
    request = {}
    request["description"] = "News load testing mute from sandbox/common/news/its_manipulation. Contact news-support for details"
    request["start_time"] = int(time.time())
    request["filters"] = []
    for check in checks:
        request["filters"].append({
            "tags": check
        })

    return request


def SetJugglerMute(durationSeconds=3600, checks=JUGGLER_CHECKS):
    request = GetGeneralJugglerRequest(checks)
    request["end_time"] = int(time.time()) + durationSeconds

    post = urllib2.Request('https://juggler-api.search.yandex.net/v2/mutes/set_mutes', json.dumps(request), headers={
        'Content-Type': 'application/json',
        'Authorization': 'OAuth ' + sdk2.Vault.data('NEWS', 'robot_ynews_juggler_oauth_token')
    })

    response = urllib2.urlopen(post).read()
    print('Juggler api responded ', response)

    return json.loads(response)["mute_id"]


def FinishJugglerMute(muteId, checks=JUGGLER_CHECKS):
    if not muteId:
        return ""

    request = GetGeneralJugglerRequest(checks)
    request["mute_id"] = muteId
    request["end_time"] = int(time.time()) + 120

    post = urllib2.Request('https://juggler-api.search.yandex.net/v2/mutes/set_mutes', json.dumps(request), headers={
        'Content-Type': 'application/json',
        'Authorization': 'OAuth ' + sdk2.Vault.data('NEWS', 'robot_ynews_juggler_oauth_token')
    })

    return urllib2.urlopen(post).read()
